package it.openutils.usermanagement.utils;

import it.openutils.usermanagement.dataobjects.User;

import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;


/**
 * @author fgiust
 * @version $Id: SecurityUtils.java 250 2007-02-13 17:31:26Z fgiust $
 */
public class SecurityUtils
{

    /**
     * Return current user logged.
     * @return Utente
     */
    public static User getCurrentUser()
    {
        User currentUser = null;
        if (SecurityContextHolder.getContext().getAuthentication() != null)
        {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null && auth.getPrincipal() instanceof User)
            {
                currentUser = (User) auth.getPrincipal();
            }
        }

        return currentUser;
    }

    /**
     * Check if the current user is in the given role.
     * @param role role to check
     * @return <code>true</code> if current user is assigned to the given role
     */
    public static Boolean isUserInRole(String role)
    {
        if (role == null || SecurityContextHolder.getContext().getAuthentication() == null)
        {
            return false;
        }
        GrantedAuthority[] roles = SecurityContextHolder.getContext().getAuthentication().getAuthorities();

        for (GrantedAuthority grantedAuthority : roles)
        {
            if (role.equals(grantedAuthority.getAuthority()))
            {
                return true;
            }
        }

        return false;
    }
}
