/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.semantic.ast.modifier.Annotation;
import java.util.Arrays;
import java.util.TreeSet;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotationParameter;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexParserVisitor;

public class ASTAnnotation
extends AbstractApexNode<Annotation> {
    public ASTAnnotation(Annotation annotation) {
        super(annotation);
    }

    @Override
    public Object jjtAccept(ApexParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getImage() {
        return ((Annotation)this.node).getType().getApexName();
    }

    public boolean suppresses(Rule rule) {
        String ruleAnno = "PMD." + rule.getName();
        if (this.hasImageEqualTo("SuppressWarnings")) {
            for (ASTAnnotationParameter param : this.findChildrenOfType(ASTAnnotationParameter.class)) {
                String image = param.getImage();
                if (image == null) continue;
                TreeSet<String> paramValues = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                paramValues.addAll(Arrays.asList(image.replaceAll("\\s+", "").split(",")));
                if (!paramValues.contains("PMD") && !paramValues.contains(ruleAnno) && !paramValues.contains("all")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isResolved() {
        return ((Annotation)this.node).getType().isResolved();
    }
}

