/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDoLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForEachStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTIfBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTIfElseBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTTryCatchFinallyBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTWhileLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNodeBase;
import net.sourceforge.pmd.lang.apex.rule.AbstractStatisticalApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public abstract class AbstractNcssCountRule
extends AbstractStatisticalApexRule {
    private Class<?> nodeClass;

    protected AbstractNcssCountRule(Class<?> nodeClass) {
        this.nodeClass = nodeClass;
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 1000.0);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(AbstractApexNodeBase node, Object data) {
        int numNodes = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            AbstractApexNodeBase n = (AbstractApexNodeBase)node.jjtGetChild(i);
            Integer treeSize = (Integer)n.jjtAccept(this, data);
            numNodes += treeSize.intValue();
        }
        if (this.nodeClass.isInstance((Object)node)) {
            DataPoint point = new DataPoint();
            point.setNode((Node)node);
            point.setScore(1.0 * (double)(++numNodes));
            point.setMessage(this.getMessage());
            this.addDataPoint(point);
        }
        return numNodes;
    }

    protected Integer countNodeChildren(Node node, Object data) {
        int lineCount = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Integer nodeCount = (Integer)((AbstractApexNodeBase)node.jjtGetChild(i)).jjtAccept(this, data);
            lineCount += nodeCount.intValue();
        }
        return ++lineCount;
    }

    @Override
    public Object visit(ASTForLoopStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTForEachStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTDoLoopStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTIfBlockStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTIfElseBlockStatement node, Object data) {
        Integer lineCount;
        Integer n = lineCount = this.countNodeChildren(node, data);
        Integer n2 = lineCount = Integer.valueOf(lineCount + 1);
        return lineCount;
    }

    @Override
    public Object visit(ASTWhileLoopStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTBreakStatement node, Object data) {
        return NumericConstants.ONE;
    }

    @Override
    public Object visit(ASTTryCatchFinallyBlockStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTContinueStatement node, Object data) {
        return NumericConstants.ONE;
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTThrowStatement node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTStatement node, Object data) {
        return NumericConstants.ONE;
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        return NumericConstants.ONE;
    }
}

