/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.AbstractApexNodeBase;
import net.sourceforge.pmd.lang.apex.rule.AbstractStatisticalApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.stat.DataPoint;

public class ExcessiveNodeCountRule
extends AbstractStatisticalApexRule {
    private Class<?> nodeClass;

    public ExcessiveNodeCountRule(Class<?> nodeClass) {
        this.nodeClass = nodeClass;
    }

    @Override
    public Object visit(AbstractApexNodeBase node, Object data) {
        int numNodes = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Integer treeSize = (Integer)((AbstractApexNodeBase)node.jjtGetChild(i)).jjtAccept(this, data);
            numNodes += treeSize.intValue();
        }
        if (this.nodeClass.isInstance((Object)node)) {
            DataPoint point = new DataPoint();
            point.setNode((Node)node);
            point.setScore(1.0 * (double)numNodes);
            point.setMessage(this.getMessage());
            this.addDataPoint(point);
        }
        return numNodes;
    }
}

