/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;
import net.sourceforge.pmd.util.NumericConstants;

public class TooManyFieldsRule
extends AbstractApexRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private Map<String, Integer> stats;
    private Map<String, ASTUserClass> nodes;
    private static final PropertyDescriptor<Integer> MAX_FIELDS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxfields").desc("Max allowable fields")).defaultValue((Object)15)).require(NumericConstraints.positive())).build();

    public TooManyFieldsRule() {
        this.definePropertyDescriptor(MAX_FIELDS_DESCRIPTOR);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 200);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        int maxFields = (Integer)this.getProperty(MAX_FIELDS_DESCRIPTOR);
        this.stats = new HashMap<String, Integer>(5);
        this.nodes = new HashMap<String, ASTUserClass>(5);
        List fields = node.findDescendantsOfType(ASTField.class);
        for (ASTField aSTField : fields) {
            ASTUserClass clazz;
            if (aSTField.getModifiers().isFinal() && aSTField.getModifiers().isStatic() || (clazz = (ASTUserClass)aSTField.getFirstParentOfType(ASTUserClass.class)) == null) continue;
            this.bumpCounterFor(clazz);
        }
        for (Map.Entry entry : this.stats.entrySet()) {
            int val = (Integer)entry.getValue();
            Node n = this.nodes.get(entry.getKey());
            if (val <= maxFields) continue;
            this.addViolation(data, n);
        }
        return data;
    }

    private void bumpCounterFor(ASTUserClass clazz) {
        String key = clazz.getImage();
        if (!this.stats.containsKey(key)) {
            this.stats.put(key, NumericConstants.ZERO);
            this.nodes.put(key, clazz);
        }
        Integer i = this.stats.get(key) + 1;
        this.stats.put(key, i);
    }
}

