/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTStandardCondition;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ApexSOQLInjectionRule
extends AbstractApexRule {
    private static final String DOUBLE = "double";
    private static final String LONG = "long";
    private static final String DECIMAL = "decimal";
    private static final String BOOLEAN = "boolean";
    private static final String ID = "id";
    private static final String INTEGER = "integer";
    private static final String JOIN = "join";
    private static final String ESCAPE_SINGLE_QUOTES = "escapeSingleQuotes";
    private static final String STRING = "String";
    private static final String DATABASE = "Database";
    private static final String QUERY = "query";
    private static final Pattern SELECT_PATTERN = Pattern.compile("^select[\\s]+?.*?$", 2);
    private final Set<String> safeVariables = new HashSet<String>();
    private final Map<String, Boolean> selectContainingVariables = new HashMap<String, Boolean>();

    public ApexSOQLInjectionRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        List methodExpr = node.findDescendantsOfType(ASTMethod.class);
        for (Object m : methodExpr) {
            this.findSafeVariablesInSignature((ASTMethod)m);
        }
        List fieldExpr = node.findDescendantsOfType(ASTFieldDeclaration.class);
        for (Object a : fieldExpr) {
            this.findSanitizedVariables((AbstractApexNode<?>)a);
            this.findSelectContainingVariables((AbstractApexNode<?>)a);
        }
        List variableDecl = node.findDescendantsOfType(ASTVariableDeclaration.class);
        for (Object a : variableDecl) {
            this.findSanitizedVariables((AbstractApexNode<?>)a);
            this.findSelectContainingVariables((AbstractApexNode<?>)a);
        }
        List assignmentCalls = node.findDescendantsOfType(ASTAssignmentExpression.class);
        for (ASTAssignmentExpression a : assignmentCalls) {
            this.findSanitizedVariables(a);
            this.findSelectContainingVariables(a);
        }
        List potentialDbQueryCalls = node.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression m : potentialDbQueryCalls) {
            if (Helper.isTestMethodOrClass(m) || !Helper.isMethodName(m, DATABASE, QUERY)) continue;
            this.reportStrings(m, data);
            this.reportVariables(m, data);
        }
        this.safeVariables.clear();
        this.selectContainingVariables.clear();
        return data;
    }

    private void findSafeVariablesInSignature(ASTMethod m) {
        for (ASTParameter p : m.findChildrenOfType(ASTParameter.class)) {
            switch (p.getType().toLowerCase(Locale.ROOT)) {
                case "id": 
                case "integer": 
                case "boolean": 
                case "decimal": 
                case "long": 
                case "double": {
                    this.safeVariables.add(Helper.getFQVariableName(p));
                    break;
                }
            }
        }
    }

    private void findSanitizedVariables(AbstractApexNode<?> node) {
        ASTVariableExpression left = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        ASTLiteralExpression literal = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class);
        ASTMethodCallExpression right = (ASTMethodCallExpression)node.getFirstChildOfType(ASTMethodCallExpression.class);
        if (literal != null && left != null) {
            if (literal.isInteger() || literal.isBoolean() || literal.isDouble()) {
                this.safeVariables.add(Helper.getFQVariableName(left));
            }
            if (literal.isString()) {
                if (SELECT_PATTERN.matcher(literal.getImage()).matches()) {
                    this.selectContainingVariables.put(Helper.getFQVariableName(left), Boolean.TRUE);
                } else {
                    this.safeVariables.add(Helper.getFQVariableName(left));
                }
            }
        }
        if (right != null && Helper.isMethodName(right, STRING, ESCAPE_SINGLE_QUOTES) && left != null) {
            this.safeVariables.add(Helper.getFQVariableName(left));
        }
        if (node instanceof ASTVariableDeclaration) {
            switch (((ASTVariableDeclaration)node).getType().toLowerCase(Locale.ROOT)) {
                case "integer": 
                case "id": 
                case "boolean": 
                case "decimal": 
                case "long": 
                case "double": {
                    this.safeVariables.add(Helper.getFQVariableName(left));
                    break;
                }
            }
        }
    }

    private void findSelectContainingVariables(AbstractApexNode<?> node) {
        ASTVariableExpression left = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        ASTBinaryExpression right = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (left != null && right != null) {
            this.recursivelyCheckForSelect(left, right);
        }
    }

    private void recursivelyCheckForSelect(ASTVariableExpression var, ASTBinaryExpression node) {
        ASTLiteralExpression literal;
        ASTMethodCallExpression methodCall;
        ASTBinaryExpression right = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (right != null) {
            this.recursivelyCheckForSelect(var, right);
        }
        ASTVariableExpression concatenatedVar = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        boolean isSafeVariable = false;
        if (concatenatedVar != null && this.safeVariables.contains(Helper.getFQVariableName(concatenatedVar))) {
            isSafeVariable = true;
        }
        if ((methodCall = (ASTMethodCallExpression)node.getFirstChildOfType(ASTMethodCallExpression.class)) != null && Helper.isMethodName(methodCall, STRING, ESCAPE_SINGLE_QUOTES)) {
            isSafeVariable = true;
        }
        if ((literal = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class)) != null) {
            if (literal.isString() && SELECT_PATTERN.matcher(literal.getImage()).matches()) {
                if (!isSafeVariable) {
                    this.selectContainingVariables.put(Helper.getFQVariableName(var), Boolean.FALSE);
                } else {
                    this.safeVariables.add(Helper.getFQVariableName(var));
                }
            }
        } else if (!isSafeVariable) {
            this.selectContainingVariables.put(Helper.getFQVariableName(var), Boolean.FALSE);
        }
    }

    private void reportStrings(ASTMethodCallExpression m, Object data) {
        HashSet setOfSafeVars = new HashSet();
        List conditions = m.findDescendantsOfType(ASTStandardCondition.class);
        for (ASTStandardCondition c : conditions) {
            List vars = c.findDescendantsOfType(ASTVariableExpression.class);
            setOfSafeVars.addAll(vars);
        }
        List binaryExpr = m.findChildrenOfType(ASTBinaryExpression.class);
        for (ASTBinaryExpression b : binaryExpr) {
            List vars = b.findDescendantsOfType(ASTVariableExpression.class);
            for (ASTVariableExpression v : vars) {
                ASTMethodCallExpression parentCall;
                boolean isSafeMethod;
                boolean isLiteral;
                String fqName = Helper.getFQVariableName(v);
                if (this.selectContainingVariables.containsKey(fqName) && (isLiteral = this.selectContainingVariables.get(fqName).booleanValue()) || setOfSafeVars.contains(v) || this.safeVariables.contains(fqName) || (isSafeMethod = Helper.isMethodName(parentCall = (ASTMethodCallExpression)v.getFirstParentOfType(ASTMethodCallExpression.class), STRING, ESCAPE_SINGLE_QUOTES) || Helper.isMethodName(parentCall, STRING, JOIN))) continue;
                this.addViolation(data, v);
            }
        }
    }

    private void reportVariables(ASTMethodCallExpression m, Object data) {
        boolean isLiteral;
        String nameFQ;
        ASTVariableExpression var = (ASTVariableExpression)m.getFirstChildOfType(ASTVariableExpression.class);
        if (var != null && this.selectContainingVariables.containsKey(nameFQ = Helper.getFQVariableName(var)) && !(isLiteral = this.selectContainingVariables.get(nameFQ).booleanValue())) {
            this.addViolation(data, var);
        }
    }
}

