/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.ast.BooleanOp;

public enum BooleanOperator {
    EQUAL("=="),
    NOT_EQUAL("!="),
    ALT_NOT_EQUAL("<>"),
    EXACTLY_EQUAL("==="),
    EXACTLY_NOT_EQUAL("!=="),
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LESS_THAN_OR_EQUAL("<="),
    GREATER_THAN_OR_EQUAL(">="),
    LOGICAL_AND("&&"),
    LOGICAL_OR("||");

    private final String symbol;

    private BooleanOperator(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static BooleanOperator valueOf(BooleanOp op) {
        switch (op) {
            case DOUBLE_EQUAL: {
                return EQUAL;
            }
            case NOT_EQUAL: {
                return NOT_EQUAL;
            }
            case ALT_NOT_EQUAL: {
                return ALT_NOT_EQUAL;
            }
            case TRIPLE_EQUAL: {
                return EXACTLY_EQUAL;
            }
            case NOT_TRIPLE_EQUAL: {
                return EXACTLY_NOT_EQUAL;
            }
            case LESS_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
            case AND: {
                return LOGICAL_AND;
            }
            case OR: {
                return LOGICAL_OR;
            }
        }
        throw new IllegalArgumentException("Invalid boolean operator " + op);
    }
}

