/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.internal.JavaCCTokenizer;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.cpp.CppTokenManager;
import net.sourceforge.pmd.util.IOUtil;

public class CPPTokenizer
extends JavaCCTokenizer {
    private boolean skipBlocks = true;
    private String skipBlocksStart;
    private String skipBlocksEnd;

    public void setProperties(Properties properties) {
        this.skipBlocks = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocks", Boolean.TRUE.toString()));
        if (this.skipBlocks) {
            String skipBlocksPattern = properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocksPattern", "#if 0|#endif");
            String[] split = skipBlocksPattern.split("\\|", 2);
            this.skipBlocksStart = split[0];
            this.skipBlocksEnd = split.length == 1 ? split[0] : split[1];
        }
    }

    private String maybeSkipBlocks(String test) throws IOException {
        if (!this.skipBlocks) {
            return test;
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(test));){
            String line;
            StringBuilder filtered = new StringBuilder(test.length());
            boolean skip = false;
            while ((line = reader.readLine()) != null) {
                if (this.skipBlocksStart.equalsIgnoreCase(line.trim())) {
                    skip = true;
                } else if (skip && this.skipBlocksEnd.equalsIgnoreCase(line.trim())) {
                    skip = false;
                }
                if (!skip) {
                    filtered.append(line);
                }
                filtered.append(PMD.EOL);
            }
            String string = filtered.toString();
            return string;
        }
    }

    protected TokenManager getLexerForSource(SourceCode sourceCode) {
        try {
            StringBuilder buffer = sourceCode.getCodeBuffer();
            return new CppTokenManager(IOUtil.skipBOM((Reader)new StringReader(this.maybeSkipBlocks(buffer.toString()))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

