/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.docs;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetLoadException;
import net.sourceforge.pmd.RuleSetLoader;
import net.sourceforge.pmd.docs.EscapeUtils;
import net.sourceforge.pmd.docs.FileWriter;
import net.sourceforge.pmd.docs.RuleSetUtils;
import net.sourceforge.pmd.docs.SidebarGenerator;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class RuleDocGenerator {
    private static final Logger LOG = Logger.getLogger(RuleDocGenerator.class.getName());
    private static final String GENERATED_WARNING = "<!-- DO NOT EDIT THIS FILE. This file is generated from file ${source}. -->";
    private static final String GENERATED_WARNING_NO_SOURCE = "<!-- DO NOT EDIT THIS FILE. This file is generated. -->";
    private static final String LANGUAGE_INDEX_FILENAME_PATTERN = "docs/pages/pmd/rules/${language.tersename}.md";
    private static final String LANGUAGE_INDEX_PERMALINK_PATTERN = "pmd_rules_${language.tersename}.html";
    private static final String RULESET_INDEX_FILENAME_PATTERN = "docs/pages/pmd/rules/${language.tersename}/${ruleset.name}.md";
    private static final String RULESET_INDEX_PERMALINK_PATTERN = "pmd_rules_${language.tersename}_${ruleset.name}.html";
    private static final String DEPRECATION_LABEL_SMALL = "<span style=\"border-radius: 0.25em; color: #fff; padding: 0.2em 0.6em 0.3em; display: inline; background-color: #d9534f; font-size: 75%;\">Deprecated</span> ";
    private static final String DEPRECATION_LABEL = "<span style=\"border-radius: 0.25em; color: #fff; padding: 0.2em 0.6em 0.3em; display: inline; background-color: #d9534f;\">Deprecated</span> ";
    private static final String DEPRECATED_RULE_PROPERTY_MARKER = "deprecated!";
    private static final String GITHUB_SOURCE_LINK = "https://github.com/pmd/pmd/blob/master/";
    private static final Map<String, String> LANGUAGE_HIGHLIGHT_MAPPER = new HashMap<String, String>();
    private final Path root;
    private final FileWriter writer;
    private final Map<String, String> allRules = new HashMap<String, String>();
    private final Map<String, String> allRulesets = new HashMap<String, String>();

    public RuleDocGenerator(FileWriter writer, Path root) {
        this.writer = Objects.requireNonNull(writer, "A file writer must be provided");
        this.root = Objects.requireNonNull(root, "Root directory must be provided");
        Path docsDir = root.resolve("docs");
        if (!Files.exists(docsDir, new LinkOption[0]) || !Files.isDirectory(docsDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Couldn't find \"docs\" subdirectory");
        }
    }

    public void generate(List<RuleSet> registeredRulesets, List<String> additionalRulesets) throws IOException {
        Map<Language, List<RuleSet>> sortedRulesets = this.sortRulesets(registeredRulesets);
        Map<Language, List<RuleSet>> sortedAdditionalRulesets = this.sortRulesets(this.resolveAdditionalRulesets(additionalRulesets));
        this.determineRuleClassSourceFiles(sortedRulesets);
        this.generateLanguageIndex(sortedRulesets, sortedAdditionalRulesets);
        this.generateRuleSetIndex(sortedRulesets);
        this.generateSidebar(sortedRulesets);
    }

    private void generateSidebar(Map<Language, List<RuleSet>> sortedRulesets) throws IOException {
        SidebarGenerator generator = new SidebarGenerator(this.writer, this.root);
        generator.generateSidebar(sortedRulesets);
    }

    private List<RuleSet> resolveAdditionalRulesets(List<String> additionalRulesets) {
        if (additionalRulesets == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleSet> rulesets = new ArrayList<RuleSet>();
        RuleSetLoader ruleSetLoader = new RuleSetLoader();
        for (String filename : additionalRulesets) {
            try {
                if (!filename.contains("pmd-test") && !filename.contains("pmd-core")) {
                    rulesets.add(ruleSetLoader.loadFromResource(filename));
                    continue;
                }
                LOG.fine("Ignoring ruleset " + filename);
            }
            catch (RuleSetLoadException e) {
                LOG.log(Level.WARNING, "ruleset file " + filename + " ignored (" + e.getMessage() + ")", e);
            }
        }
        return rulesets;
    }

    private Path getAbsoluteOutputPath(String filename) {
        return this.root.resolve(FilenameUtils.normalize((String)filename));
    }

    private Map<Language, List<RuleSet>> sortRulesets(List<RuleSet> rulesets) {
        SortedMap rulesetsByLanguage = rulesets.stream().collect(Collectors.groupingBy(RuleDocGenerator::getRuleSetLanguage, TreeMap::new, Collectors.toCollection(ArrayList::new)));
        for (List rulesetsOfOneLanguage : rulesetsByLanguage.values()) {
            rulesetsOfOneLanguage.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        }
        return rulesetsByLanguage;
    }

    private static Language getRuleSetLanguage(RuleSet ruleset) {
        Collection rules = ruleset.getRules();
        if (rules.isEmpty()) {
            throw new RuntimeException("Ruleset " + ruleset.getFileName() + " is empty!");
        }
        return ((Rule)rules.iterator().next()).getLanguage();
    }

    private void generateLanguageIndex(Map<Language, List<RuleSet>> rulesets, Map<Language, List<RuleSet>> sortedAdditionalRulesets) throws IOException {
        for (Map.Entry<Language, List<RuleSet>> entry : rulesets.entrySet()) {
            String languageTersename = entry.getKey().getTerseName();
            String filename = LANGUAGE_INDEX_FILENAME_PATTERN.replace("${language.tersename}", languageTersename);
            Path path = this.getAbsoluteOutputPath(filename);
            LinkedList<String> lines = new LinkedList<String>();
            lines.add("---");
            lines.add("title: " + entry.getKey().getName() + " Rules");
            lines.add("tags: [rule_references, " + languageTersename + "]");
            lines.add("summary: Index of all built-in rules available for " + entry.getKey().getName());
            lines.add("language_name: " + entry.getKey().getName());
            lines.add("permalink: " + LANGUAGE_INDEX_PERMALINK_PATTERN.replace("${language.tersename}", languageTersename));
            lines.add("folder: pmd/rules");
            lines.add("---");
            lines.add(GENERATED_WARNING_NO_SOURCE);
            for (RuleSet ruleset : entry.getValue()) {
                lines.add("## " + ruleset.getName());
                lines.add("");
                lines.add("{% include callout.html content=\"" + RuleDocGenerator.getRuleSetDescriptionSingleLine(ruleset) + "\" %}");
                lines.add("");
                for (Rule rule : this.getSortedRules(ruleset)) {
                    String link = RULESET_INDEX_PERMALINK_PATTERN.replace("${language.tersename}", languageTersename).replace("${ruleset.name}", RuleSetUtils.getRuleSetFilename(ruleset));
                    if (rule instanceof RuleReference) {
                        RuleReference ref = (RuleReference)rule;
                        if (ruleset.getFileName().equals(ref.getRuleSetReference().getRuleSetFileName())) {
                            lines.add("*   [" + rule.getName() + "](" + link + "#" + rule.getName().toLowerCase(Locale.ROOT) + "): " + DEPRECATION_LABEL_SMALL + "The rule has been renamed. Use instead [" + ref.getRule().getName() + "](" + link + "#" + ref.getRule().getName().toLowerCase(Locale.ROOT) + ").");
                            continue;
                        }
                        String otherLink = RULESET_INDEX_PERMALINK_PATTERN.replace("${language.tersename}", languageTersename).replace("${ruleset.name}", RuleSetUtils.getRuleSetFilename(ref.getRuleSetReference().getRuleSetFileName()));
                        lines.add("*   [" + rule.getName() + "](" + link + "#" + rule.getName().toLowerCase(Locale.ROOT) + "): " + DEPRECATION_LABEL_SMALL + "The rule has been moved to another ruleset. Use instead [" + ref.getRule().getName() + "](" + otherLink + "#" + ref.getRule().getName().toLowerCase(Locale.ROOT) + ").");
                        continue;
                    }
                    link = link + "#" + rule.getName().toLowerCase(Locale.ROOT);
                    lines.add("*   [" + rule.getName() + "](" + link + "): " + (rule.isDeprecated() ? DEPRECATION_LABEL_SMALL : "") + RuleDocGenerator.getShortRuleDescription(rule));
                }
                lines.add("");
            }
            List<RuleSet> additionalRulesetsForLanguage = sortedAdditionalRulesets.get(entry.getKey());
            if (additionalRulesetsForLanguage != null) {
                lines.add("## Additional rulesets");
                lines.add("");
                for (RuleSet ruleset : additionalRulesetsForLanguage) {
                    boolean deprecated = RuleSetUtils.isRuleSetDeprecated(ruleset);
                    String rulesetName = ruleset.getName() + " (`" + RuleSetUtils.getRuleSetClasspath(ruleset) + "`)";
                    if (!deprecated) {
                        lines.add("*   " + rulesetName + ":");
                        lines.add("");
                        lines.add("    " + RuleDocGenerator.getRuleSetDescriptionSingleLine(ruleset));
                        lines.add("");
                    } else {
                        lines.add("*   " + rulesetName + ":");
                        lines.add("");
                        lines.add("    <span style=\"border-radius: 0.25em; color: #fff; padding: 0.2em 0.6em 0.3em; display: inline; background-color: #d9534f; font-size: 75%;\">Deprecated</span>  This ruleset is for backwards compatibility.");
                        lines.add("");
                    }
                    lines.add("    It contains the following rules:");
                    lines.add("");
                    StringBuilder rules = new StringBuilder();
                    for (Rule rule : this.getSortedRules(ruleset)) {
                        if (rules.length() == 0) {
                            rules.append("    ");
                        } else {
                            rules.append(", ");
                        }
                        Rule resolvedRule = RuleSetUtils.resolveRuleReferences(rule);
                        if (resolvedRule instanceof RuleReference) {
                            RuleReference ref = (RuleReference)resolvedRule;
                            String otherLink = RULESET_INDEX_PERMALINK_PATTERN.replace("${language.tersename}", languageTersename).replace("${ruleset.name}", RuleSetUtils.getRuleSetFilename(ref.getRuleSetReference().getRuleSetFileName()));
                            rules.append("[").append(ref.getName()).append("](");
                            rules.append(otherLink).append("#").append(ref.getRule().getName().toLowerCase(Locale.ROOT)).append(")");
                            continue;
                        }
                        rules.append(rule.getName());
                    }
                    lines.add(rules.toString());
                    lines.add("");
                }
                lines.add("");
            }
            System.out.println("Generated " + path);
            this.writer.write(path, lines);
        }
    }

    private static String getShortRuleDescription(Rule rule) {
        String htmlEscaped = StringEscapeUtils.escapeHtml4((String)StringUtils.abbreviate((String)StringUtils.stripToEmpty((String)rule.getDescription().replaceAll("\n+|\r+", " ").replaceAll("\\|", "\\\\|").replaceAll("`", "'").replaceAll("\\*", "")), (int)100));
        return EscapeUtils.preserveRuleTagQuotes(htmlEscaped);
    }

    private static String getRuleSetDescriptionSingleLine(RuleSet ruleset) {
        String description = ruleset.getDescription();
        description = StringEscapeUtils.escapeHtml4((String)description);
        description = description.replaceAll("\\n|\\r", " ");
        description = StringUtils.stripToEmpty((String)description);
        return EscapeUtils.preserveRuleTagQuotes(description);
    }

    private static List<String> toLines(String s) {
        return Arrays.asList(s.split("\r\n|\n"));
    }

    private void generateRuleSetIndex(Map<Language, List<RuleSet>> rulesets) throws IOException {
        for (Map.Entry<Language, List<RuleSet>> entry : rulesets.entrySet()) {
            Language language = entry.getKey();
            String languageTersename = language.getTerseName();
            String languageName = language.getName();
            for (RuleSet ruleset : entry.getValue()) {
                String rulesetFilename = RuleSetUtils.getRuleSetFilename(ruleset);
                String filename = RULESET_INDEX_FILENAME_PATTERN.replace("${language.tersename}", languageTersename).replace("${ruleset.name}", rulesetFilename);
                Path path = this.getAbsoluteOutputPath(filename);
                String permalink = RULESET_INDEX_PERMALINK_PATTERN.replace("${language.tersename}", languageTersename).replace("${ruleset.name}", rulesetFilename);
                String ruleSetSourceFilepath = "../" + this.allRulesets.get(ruleset.getFileName());
                LinkedList<String> lines = new LinkedList<String>();
                lines.add("---");
                lines.add("title: " + ruleset.getName());
                lines.add("summary: " + RuleDocGenerator.getRuleSetDescriptionSingleLine(ruleset));
                lines.add("permalink: " + permalink);
                lines.add("folder: pmd/rules/" + languageTersename);
                lines.add("sidebaractiveurl: /" + LANGUAGE_INDEX_PERMALINK_PATTERN.replace("${language.tersename}", languageTersename));
                lines.add("editmepath: " + ruleSetSourceFilepath);
                lines.add("keywords: " + this.getRuleSetKeywords(ruleset));
                lines.add("language: " + languageName);
                lines.add("---");
                lines.add(GENERATED_WARNING.replace("${source}", ruleSetSourceFilepath));
                for (Rule rule : this.getSortedRules(ruleset)) {
                    lines.add("## " + rule.getName());
                    lines.add("");
                    if (rule instanceof RuleReference) {
                        RuleReference ref = (RuleReference)rule;
                        if (ruleset.getFileName().equals(ref.getRuleSetReference().getRuleSetFileName())) {
                            lines.add(DEPRECATION_LABEL);
                            lines.add("");
                            lines.add("This rule has been renamed. Use instead: [" + ref.getRule().getName() + "](#" + ref.getRule().getName().toLowerCase(Locale.ROOT) + ")");
                            lines.add("");
                        } else {
                            String otherLink = RULESET_INDEX_PERMALINK_PATTERN.replace("${language.tersename}", languageTersename).replace("${ruleset.name}", RuleSetUtils.getRuleSetFilename(ref.getRuleSetReference().getRuleSetFileName()));
                            lines.add(DEPRECATION_LABEL);
                            lines.add("");
                            lines.add("The rule has been moved to another ruleset. Use instead: [" + ref.getRule().getName() + "](" + (String)otherLink + "#" + ref.getRule().getName().toLowerCase(Locale.ROOT) + ")");
                            lines.add("");
                        }
                    }
                    if (rule.isDeprecated()) {
                        lines.add(DEPRECATION_LABEL);
                        lines.add("");
                    }
                    if (rule.getSince() != null) {
                        lines.add("**Since:** PMD " + rule.getSince());
                        lines.add("");
                    }
                    lines.add("**Priority:** " + rule.getPriority() + " (" + rule.getPriority().getPriority() + ")");
                    lines.add("");
                    if (rule.getMinimumLanguageVersion() != null) {
                        lines.add("**Minimum Language Version:** " + rule.getLanguage().getName() + " " + rule.getMinimumLanguageVersion().getVersion());
                        lines.add("");
                    }
                    lines.addAll(EscapeUtils.escapeLines(RuleDocGenerator.toLines(RuleDocGenerator.stripIndentation(rule.getDescription()))));
                    lines.add("");
                    XPathRule xpathRule = this.asXPathRule(rule);
                    if (xpathRule != null) {
                        lines.add("**This rule is defined by the following XPath expression:**");
                        lines.add("``` xpath");
                        lines.addAll(RuleDocGenerator.toLines(StringUtils.stripToEmpty((String)xpathRule.getXPathExpression())));
                        lines.add("```");
                    } else {
                        lines.add("**This rule is defined by the following Java class:** [" + rule.getRuleClass() + "](" + GITHUB_SOURCE_LINK + this.allRules.get(rule.getRuleClass()) + ")");
                    }
                    lines.add("");
                    if (!rule.getExamples().isEmpty()) {
                        lines.add("**Example(s):**");
                        lines.add("");
                        for (String example : rule.getExamples()) {
                            lines.add("``` " + RuleDocGenerator.mapLanguageForHighlighting(languageTersename));
                            lines.addAll(RuleDocGenerator.toLines("{%raw%}" + StringUtils.stripToEmpty((String)example) + "{%endraw%}"));
                            lines.add("```");
                            lines.add("");
                        }
                    }
                    ArrayList properties = new ArrayList(rule.getPropertyDescriptors());
                    properties.remove(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR);
                    properties.remove(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR);
                    properties.remove(XPathRule.XPATH_DESCRIPTOR);
                    properties.remove(XPathRule.VERSION_DESCRIPTOR);
                    if (!properties.isEmpty()) {
                        lines.add("**This rule has the following properties:**");
                        lines.add("");
                        lines.add("|Name|Default Value|Description|Multivalued|");
                        lines.add("|----|-------------|-----------|-----------|");
                        for (PropertyDescriptor propertyDescriptor : properties) {
                            String description = propertyDescriptor.description();
                            boolean isDeprecated = RuleDocGenerator.isDeprecated(propertyDescriptor);
                            if (isDeprecated) {
                                description = description.substring(DEPRECATED_RULE_PROPERTY_MARKER.length());
                            }
                            String defaultValue = this.determineDefaultValueAsString(propertyDescriptor, rule, true);
                            String multiValued = "no";
                            if (propertyDescriptor.isMultiValue()) {
                                MultiValuePropertyDescriptor multiValuePropertyDescriptor = (MultiValuePropertyDescriptor)propertyDescriptor;
                                multiValued = "yes. Delimiter is '" + multiValuePropertyDescriptor.multiValueDelimiter() + "'.";
                            }
                            lines.add("|" + EscapeUtils.escapeMarkdown(StringEscapeUtils.escapeHtml4((String)propertyDescriptor.name())) + "|" + EscapeUtils.escapeMarkdown(StringEscapeUtils.escapeHtml4((String)defaultValue)) + "|" + EscapeUtils.escapeMarkdown((isDeprecated ? DEPRECATION_LABEL_SMALL : "") + StringEscapeUtils.escapeHtml4((String)description)) + "|" + EscapeUtils.escapeMarkdown(StringEscapeUtils.escapeHtml4((String)multiValued)) + "|");
                        }
                        lines.add("");
                    }
                    if (properties.isEmpty()) {
                        lines.add("**Use this rule by referencing it:**");
                    } else {
                        lines.add("**Use this rule with the default properties by just referencing it:**");
                    }
                    lines.add("``` xml");
                    lines.add("<rule ref=\"category/" + languageTersename + "/" + rulesetFilename + ".xml/" + rule.getName() + "\" />");
                    lines.add("```");
                    lines.add("");
                    if (!properties.stream().anyMatch(it -> !RuleDocGenerator.isDeprecated(it))) continue;
                    lines.add("**Use this rule and customize it:**");
                    lines.add("``` xml");
                    lines.add("<rule ref=\"category/" + languageTersename + "/" + rulesetFilename + ".xml/" + rule.getName() + "\">");
                    lines.add("    <properties>");
                    for (PropertyDescriptor propertyDescriptor : properties) {
                        if (RuleDocGenerator.isDeprecated(propertyDescriptor)) continue;
                        String defaultValue = this.determineDefaultValueAsString(propertyDescriptor, rule, false);
                        lines.add("        <property name=\"" + propertyDescriptor.name() + "\" value=\"" + defaultValue + "\" />");
                    }
                    lines.add("    </properties>");
                    lines.add("</rule>");
                    lines.add("```");
                    lines.add("");
                }
                this.writer.write(path, lines);
                System.out.println("Generated " + path);
            }
        }
    }

    private XPathRule asXPathRule(Rule rule) {
        if (rule instanceof XPathRule) {
            return (XPathRule)rule;
        }
        if (rule instanceof RuleReference && ((RuleReference)rule).getRule() instanceof XPathRule) {
            return (XPathRule)((RuleReference)rule).getRule();
        }
        return null;
    }

    private static boolean isDeprecated(PropertyDescriptor<?> propertyDescriptor) {
        return propertyDescriptor.description() != null && propertyDescriptor.description().toLowerCase(Locale.ROOT).startsWith(DEPRECATED_RULE_PROPERTY_MARKER);
    }

    private String determineDefaultValueAsString(PropertyDescriptor<?> propertyDescriptor, Rule rule, boolean pad) {
        String defaultValue = "";
        Object realDefaultValue = rule.getProperty(propertyDescriptor);
        PropertyDescriptor<?> captured = propertyDescriptor;
        if (realDefaultValue != null) {
            defaultValue = captured.asDelimitedString(realDefaultValue);
            if (pad && propertyDescriptor.isMultiValue()) {
                MultiValuePropertyDescriptor multiPropertyDescriptor = (MultiValuePropertyDescriptor)propertyDescriptor;
                defaultValue = defaultValue.replaceAll(Pattern.quote(String.valueOf(multiPropertyDescriptor.multiValueDelimiter())), " " + multiPropertyDescriptor.multiValueDelimiter() + " ");
            }
        }
        return defaultValue;
    }

    private static String stripIndentation(String description) {
        int indentation;
        if (description == null || description.isEmpty()) {
            return "";
        }
        String stripped = StringUtils.stripStart((String)description, (String)"\n\r");
        stripped = StringUtils.stripEnd((String)stripped, (String)"\n\r ");
        int strLen = stripped.length();
        for (indentation = 0; Character.isWhitespace(stripped.charAt(indentation)) && indentation < strLen; ++indentation) {
        }
        String[] lines = stripped.split("\\n");
        String prefix = StringUtils.repeat((char)' ', (int)indentation);
        StringBuilder result = new StringBuilder(stripped.length());
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i > 0) {
                    result.append("\n");
                }
                result.append(StringUtils.removeStart((String)line, (String)prefix));
            }
        } else {
            result.append(stripped);
        }
        return result.toString();
    }

    private static String mapLanguageForHighlighting(String languageTersename) {
        if (LANGUAGE_HIGHLIGHT_MAPPER.containsKey(languageTersename)) {
            return LANGUAGE_HIGHLIGHT_MAPPER.get(languageTersename);
        }
        return languageTersename;
    }

    private String getRuleSetKeywords(RuleSet ruleset) {
        LinkedList<String> ruleNames = new LinkedList<String>();
        for (Rule rule : ruleset.getRules()) {
            ruleNames.add(rule.getName());
        }
        return ruleset.getName() + ", " + StringUtils.join(ruleNames, (String)", ");
    }

    private List<Rule> getSortedRules(RuleSet ruleset) {
        ArrayList<Rule> sortedRules = new ArrayList<Rule>(ruleset.getRules());
        Collections.sort(sortedRules, new Comparator<Rule>(){

            @Override
            public int compare(Rule o1, Rule o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return sortedRules;
    }

    private void determineRuleClassSourceFiles(Map<Language, List<RuleSet>> sortedRulesets) {
        for (List<RuleSet> rulesets : sortedRulesets.values()) {
            for (RuleSet ruleset : rulesets) {
                String rulesetFilename = FilenameUtils.normalize((String)StringUtils.chomp((String)ruleset.getFileName()), (boolean)true);
                this.allRulesets.put(ruleset.getFileName(), rulesetFilename);
                for (Rule rule : ruleset.getRules()) {
                    String ruleClass = rule.getRuleClass();
                    String relativeSourceFilename = ruleClass.replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".java";
                    this.allRules.put(ruleClass, FilenameUtils.normalize((String)relativeSourceFilename, (boolean)true));
                }
            }
        }
        try {
            Files.walkFileTree(this.root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String path = file.toString();
                    if (path.contains("src")) {
                        String foundRuleClass = null;
                        for (Map.Entry entry : RuleDocGenerator.this.allRules.entrySet()) {
                            if (!path.endsWith((String)entry.getValue())) continue;
                            foundRuleClass = (String)entry.getKey();
                            break;
                        }
                        if (foundRuleClass != null) {
                            Path foundPath = RuleDocGenerator.this.root.relativize(file);
                            RuleDocGenerator.this.allRules.put(foundRuleClass, FilenameUtils.normalize((String)foundPath.toString(), (boolean)true));
                        }
                        String foundRuleset = null;
                        for (Map.Entry entry : RuleDocGenerator.this.allRulesets.entrySet()) {
                            if (!path.endsWith((String)entry.getValue())) continue;
                            foundRuleset = (String)entry.getKey();
                            break;
                        }
                        if (foundRuleset != null) {
                            Path foundPath = RuleDocGenerator.this.root.relativize(file);
                            RuleDocGenerator.this.allRulesets.put(foundRuleset, FilenameUtils.normalize((String)foundPath.toString(), (boolean)true));
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LANGUAGE_HIGHLIGHT_MAPPER.put("ecmascript", "javascript");
        LANGUAGE_HIGHLIGHT_MAPPER.put("pom", "xml");
        LANGUAGE_HIGHLIGHT_MAPPER.put("apex", "java");
        LANGUAGE_HIGHLIGHT_MAPPER.put("plsql", "sql");
    }
}

