/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.internal.JavaCCTokenizer;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ecmascript5.Ecmascript5TokenManager;
import net.sourceforge.pmd.lang.ecmascript5.ast.Token;
import net.sourceforge.pmd.util.IOUtil;

public class EcmascriptTokenizer
extends JavaCCTokenizer {
    protected TokenManager getLexerForSource(SourceCode sourceCode) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        return new Ecmascript5TokenManager(IOUtil.skipBOM((Reader)new StringReader(buffer.toString())));
    }

    protected TokenEntry processToken(Tokens tokenEntries, GenericToken currentToken, String filename) {
        return new TokenEntry(this.getTokenImage(currentToken), filename, currentToken.getBeginLine());
    }

    private String getTokenImage(GenericToken token) {
        Token jsToken = (Token)token;
        if (jsToken.kind == 64 || jsToken.kind == 68) {
            return token.getImage().replaceAll("(?<!\\\\)\\\\(\\r\\n|\\r|\\n)", "");
        }
        return token.getImage();
    }
}

