/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scala.language;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sonar.plugins.scala.language.CodeDetector;
import org.sonar.plugins.scala.language.CommentType;
import org.sonar.plugins.scala.util.StringUtils;

public class Comment {
    private final CommentType type;
    private final List<String> lines;

    public Comment(String content, CommentType type) throws IOException {
        this.lines = StringUtils.convertStringToListOfLines(content);
        this.type = type;
    }

    public int getNumberOfLines() {
        return this.lines.size() - this.getNumberOfBlankLines() - this.getNumberOfCommentedOutLinesOfCode();
    }

    public int getNumberOfBlankLines() {
        int numberOfBlankLines = 0;
        for (String comment : this.lines) {
            boolean isBlank = true;
            for (int i = 0; isBlank && i < comment.length(); ++i) {
                char character = comment.charAt(i);
                if (Character.isWhitespace(character) || character == '*' || character == '/') continue;
                isBlank = false;
            }
            if (!isBlank) continue;
            ++numberOfBlankLines;
        }
        return numberOfBlankLines;
    }

    public int getNumberOfCommentedOutLinesOfCode() {
        if (this.isDocComment()) {
            return 0;
        }
        int numberOfCommentedOutLinesOfCode = 0;
        for (String line : this.lines) {
            String strippedLine = org.apache.commons.lang3.StringUtils.strip((String)line, (String)" /*");
            if (!CodeDetector.hasDetectedCode(strippedLine)) continue;
            ++numberOfCommentedOutLinesOfCode;
        }
        return numberOfCommentedOutLinesOfCode;
    }

    public boolean isDocComment() {
        return this.type == CommentType.DOC;
    }

    public boolean isHeaderComment() {
        return this.type == CommentType.HEADER;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append(this.lines).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append(this.lines, other.lines).isEquals();
    }

    public String toString() {
        String firstLine = this.lines.isEmpty() ? "" : this.lines.get(0);
        String lastLine = this.lines.isEmpty() ? "" : this.lines.get(this.lines.size() - 1);
        return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("firstLine", (Object)firstLine).append("lastLine", (Object)lastLine).append("numberOfLines", this.getNumberOfLines()).append("numberOfCommentedOutLinesOfCode", this.getNumberOfCommentedOutLinesOfCode()).toString();
    }
}

