/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.scala.ast;

import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.scala.ast.ScalaNode;
import net.sourceforge.pmd.lang.scala.ast.ScalaParserVisitor;
import scala.meta.Tree;
import scala.meta.inputs.Position;

abstract class AbstractScalaNode<T extends Tree>
extends AbstractNode
implements ScalaNode<T> {
    private final T node;
    private final Position pos;

    AbstractScalaNode(T treeNode) {
        super(0);
        this.node = treeNode;
        this.pos = this.node.pos();
    }

    @Override
    public boolean isImplicit() {
        return this.pos.end() - this.pos.start() == 0;
    }

    public int getBeginLine() {
        return this.pos.startLine() + 1;
    }

    public int getBeginColumn() {
        return this.pos.startColumn() + 1;
    }

    public int getEndLine() {
        return this.pos.endLine() + 1;
    }

    public int getEndColumn() {
        return this.pos.endColumn();
    }

    public void testingOnlySetBeginColumn(int i) {
        throw new UnsupportedOperationException();
    }

    public void testingOnlySetBeginLine(int i) {
        throw new UnsupportedOperationException();
    }

    public void testingOnlySetEndColumn(int i) {
        throw new UnsupportedOperationException();
    }

    public void testingOnlySetEndLine(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract <D, R> R accept(ScalaParserVisitor<D, R> var1, D var2);

    @Override
    public T getNode() {
        return this.node;
    }

    @Override
    public ScalaNode<?> jjtGetChild(int index) {
        return (ScalaNode)super.jjtGetChild(index);
    }

    @Override
    public ScalaNode<?> jjtGetParent() {
        return (ScalaNode)super.jjtGetParent();
    }

    public String getXPathNodeName() {
        return this.node.productPrefix().replace(".", "");
    }
}

