/*
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */

package net.sourceforge.pmd.lang.scala.ast;

import net.sourceforge.pmd.annotation.InternalApi;

import scala.meta.Name;

/**
 * The ASTNameAnonymous node implementation.
 */
public class ASTNameAnonymous extends AbstractScalaNode<Name.Anonymous> {

    @Deprecated
    @InternalApi
    public ASTNameAnonymous(Name.Anonymous scalaNode) {
        super(scalaNode);
    }

    @Override
    public <D, R> R accept(ScalaParserVisitor<D, R> visitor, D data) {
        return visitor.visit(this, data);
    }

    @Override
    public String getImage() {
        return node.value();
    }
}
