/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.sourceforge.pmd.cpd.CPD;
import org.junit.After;
import org.junit.Before;

public abstract class BaseCPDCLITest {
    private ByteArrayOutputStream bufferStdout;
    private PrintStream originalStdout;
    private PrintStream originalStderr;

    @Before
    public void setup() throws UnsupportedEncodingException {
        this.originalStdout = System.out;
        this.originalStderr = System.err;
        this.bufferStdout = new ByteArrayOutputStream();
        System.setOut(new PrintStream((OutputStream)this.bufferStdout, false, "UTF-8"));
        System.setErr(System.out);
    }

    @After
    public void teardown() {
        System.setOut(this.originalStdout);
        System.setErr(this.originalStderr);
    }

    public final String getOutput() {
        try {
            return this.bufferStdout.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void runCPD(String ... args) {
        System.setProperty("net.sourceforge.pmd.cli.noExit", "true");
        CPD.main((String[])args);
    }
}

