/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j;

import fj.F2;
import fj.data.LazyString;
import fj.data.List;
import net.sourceforge.reb4j.AbstractExpression;
import net.sourceforge.reb4j.Alternative;

public final class Alternation
extends AbstractExpression
implements Alternative {
    private static final long serialVersionUID = 1L;
    public final List<Alternative> alternatives;

    private Alternation(List<Alternative> alternatives) {
        if (alternatives == null) {
            throw new NullPointerException("alternatives");
        }
        this.alternatives = alternatives;
    }

    Alternation(Alternation left, Alternation right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.alternatives = left.alternatives.append(right.alternatives);
    }

    Alternation(Alternation left, Alternative right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.alternatives = left.alternatives.append(List.single((Object)right));
    }

    Alternation(Alternative left, Alternation right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.alternatives = right.alternatives.cons((Object)left);
    }

    Alternation(Alternative left, Alternative right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.alternatives = List.list((Object[])new Alternative[]{left, right});
    }

    public static Alternation alternatives(Alternative first, Alternative second, Alternative ... rest) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        if (rest == null) {
            throw new NullPointerException("rest");
        }
        return new Alternation((List<Alternative>)List.list((Object[])rest).cons((Object)second).cons((Object)first));
    }

    @Override
    public LazyString expression() {
        return (LazyString)this.alternatives.tail().foldLeft((F2)new F2<LazyString, Alternative, LazyString>(){

            public LazyString f(LazyString a, Alternative b) {
                return a.append("|").append(b.expression());
            }
        }, (Object)((Alternative)this.alternatives.head()).expression());
    }

    @Override
    public Alternation or(Alternation right) {
        return new Alternation(this, right);
    }

    @Override
    public Alternation or(Alternative right) {
        return new Alternation(this, right);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alternatives.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alternation other = (Alternation)obj;
        return this.alternatives.equals(other.alternatives);
    }
}

