/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j;

import fj.data.LazyString;
import net.sourceforge.reb4j.AbstractQuantifiableSequenceableAlternative;
import net.sourceforge.reb4j.Expression;
import net.sourceforge.reb4j.Flag;
import net.sourceforge.reb4j.Quantifiable;

public final class Group
extends AbstractQuantifiableSequenceableAlternative
implements Quantifiable {
    private static final long serialVersionUID = 1L;
    public final Expression nested;
    private final LazyString expression;

    private Group(Expression nested, LazyString opening) {
        if (nested == null) {
            throw new NullPointerException("nested");
        }
        assert (opening != null);
        this.nested = nested;
        this.expression = opening.append(nested.expression()).append(")");
    }

    @Override
    public LazyString expression() {
        return this.expression;
    }

    public static Group capture(Expression nested) {
        return new Group(nested, LazyString.str((String)"("));
    }

    public static Group nonCapturing(Expression nested) {
        return new Group(nested, LazyString.str((String)"(?:"));
    }

    public static Group independent(Expression nested) {
        return new Group(nested, LazyString.str((String)"(?>"));
    }

    public static Group positiveLookAhead(Expression nested) {
        return new Group(nested, LazyString.str((String)"(?="));
    }

    public static Group negativeLookAhead(Expression nested) {
        return new Group(nested, LazyString.str((String)"(?!"));
    }

    public static Group positiveLookBehind(Expression nested) {
        return new Group(nested, LazyString.str((String)"(?<="));
    }

    public static Group negativeLookBehind(Expression nested) {
        return new Group(nested, LazyString.str((String)"(?<!"));
    }

    public static Group enableFlags(Expression nested, Flag ... flags) {
        return new Group(nested, LazyString.str((String)"(?").append(Flag.toString(flags)).append(":"));
    }

    public static Group disableFlags(Expression nested, Flag ... flags) {
        return new Group(nested, LazyString.str((String)"(?-").append(Flag.toString(flags)).append(":"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.nested.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return this.expression.equals(other.expression) && this.nested.equals(other.nested);
    }
}

