/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableSynonym;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import sf.util.Utility;

final class SynonymRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SynonymRetriever.class.getName());

    SynonymRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveSynonymInformation(InclusionRule synonymInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableSynonym> synonymFilter = new InclusionRuleFilter<MutableSynonym>(synonymInclusionRule, false);
        if (synonymFilter.isExcludeAll()) {
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasSynonymsSql()) {
            LOGGER.log(Level.FINE, "Synonym definition SQL statement was not provided");
            return;
        }
        String synonymsDefinitionSql = informationSchemaViews.getSynonymsSql();
        Collection<Schema> schemas = this.database.getSchemaNames();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(synonymsDefinitionSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("SYNONYM_CATALOG"));
                String schemaName = this.quotedName(results.getString("SYNONYM_SCHEMA"));
                String synonymName = this.quotedName(results.getString("SYNONYM_NAME"));
                String referencedObjectCatalogName = this.quotedName(results.getString("REFERENCED_OBJECT_CATALOG"));
                String referencedObjectSchemaName = this.quotedName(results.getString("REFERENCED_OBJECT_SCHEMA"));
                String referencedObjectName = this.quotedName(results.getString("REFERENCED_OBJECT_NAME"));
                if (Utility.isBlank(referencedObjectName)) {
                    LOGGER.log(Level.FINE, String.format("No reference for synonym, %s.%s.%s", catalogName, schemaName, synonymName));
                    continue;
                }
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                SchemaReference referencedSchema = new SchemaReference(referencedObjectCatalogName, referencedObjectSchemaName);
                if (!schemas.contains(schema) && !schemas.contains(referencedSchema)) continue;
                MutableTable referencedTable = this.lookupTable(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName);
                MutableRoutine referencedRoutine = this.lookupRoutine(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName, referencedObjectName);
                AbstractDatabaseObject referencedObject = referencedTable != null ? referencedTable : (referencedRoutine != null ? referencedRoutine : new AbstractDatabaseObject(referencedSchema, referencedObjectName){
                    private static final long serialVersionUID = -2212843304418302122L;
                });
                MutableSynonym synonym = new MutableSynonym(schema, synonymName);
                synonym.setReferencedObject(referencedObject);
                synonym.addAttributes(results.getAttributes());
                if (!synonymFilter.include(synonym)) continue;
                this.database.addSynonym(synonym);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve synonyms", e);
        }
    }
}

