/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import sf.util.Utility;

public final class SchemaReference
implements Schema {
    private static final long serialVersionUID = -5309848447599233878L;
    private final String catalogName;
    private final String schemaName;
    private transient String fullName;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();

    public SchemaReference() {
        this(null, null);
    }

    public SchemaReference(String catalogName, String schemaName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public int compareTo(NamedObject otherSchemaRef) {
        if (otherSchemaRef == null) {
            return -1;
        }
        return this.getFullName().replaceAll("\"", "").compareTo(otherSchemaRef.getFullName().replaceAll("\"", ""));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaReference other = (SchemaReference)obj;
        if (this.attributeMap == null ? other.attributeMap != null : !this.attributeMap.equals(other.attributeMap)) {
            return false;
        }
        if (this.catalogName == null ? other.catalogName != null : !this.catalogName.equals(other.catalogName)) {
            return false;
        }
        return !(this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName));
    }

    @Override
    public final Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public final <T> T getAttribute(String name, T defaultValue) {
        Object attributeValue = this.getAttribute(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return (T)attributeValue;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public String getLookupKey() {
        return this.getFullName();
    }

    @Override
    public String getName() {
        return this.schemaName;
    }

    @Override
    public String getRemarks() {
        return "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeMap == null ? 0 : this.attributeMap.hashCode());
        result = 31 * result + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        return result;
    }

    @Override
    public final void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    public String toString() {
        return this.getFullName();
    }

    private void buildFullName() {
        if (this.fullName == null) {
            boolean hasCatalogName = !Utility.isBlank(this.catalogName);
            boolean hasSchemaName = !Utility.isBlank(this.getName());
            this.fullName = (hasCatalogName ? this.catalogName : "") + (hasCatalogName && hasSchemaName ? "." : "") + (hasSchemaName ? this.getName() : "");
        }
    }
}

