/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.InclusionRule;
import sf.util.Utility;

public final class RegularExpressionRule
implements InclusionRule {
    private static final Logger LOGGER = Logger.getLogger(RegularExpressionRule.class.getName());
    private static final long serialVersionUID = 3443758881974362293L;
    private final Pattern patternInclude;
    private final Pattern patternExclude;

    public RegularExpressionRule(Pattern patternInclude, Pattern patternExclude) {
        String ALL = ".*";
        String NONE = "";
        this.patternInclude = patternInclude == null ? Pattern.compile(".*") : patternInclude;
        this.patternExclude = patternExclude == null ? Pattern.compile("") : patternExclude;
    }

    public RegularExpressionRule(String patternInclude, String patternExclude) {
        this(patternInclude == null ? null : Pattern.compile(patternInclude), patternExclude == null ? null : Pattern.compile(patternExclude));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegularExpressionRule other = (RegularExpressionRule)obj;
        if (this.patternExclude == null ? other.patternExclude != null : !this.patternExclude.pattern().equals(other.patternExclude.pattern())) {
            return false;
        }
        return !(this.patternInclude == null ? other.patternInclude != null : !this.patternInclude.pattern().equals(other.patternInclude.pattern()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.patternExclude == null ? 0 : this.patternExclude.hashCode());
        result = 31 * result + (this.patternInclude == null ? 0 : this.patternInclude.hashCode());
        return result;
    }

    @Override
    public boolean include(String text) {
        String actionMessage;
        boolean include = false;
        if (!Utility.isBlank(text)) {
            if (!this.patternInclude.matcher(text).matches()) {
                actionMessage = "Excluding \"" + text + "\" since it does not match the include pattern";
            } else if (this.patternExclude.matcher(text).matches()) {
                actionMessage = "Excluding \"" + text + "\" since it matches the exclude pattern";
            } else {
                actionMessage = "Including \"" + text + "\"";
                include = true;
            }
        } else {
            actionMessage = "Excluding, since text is bank";
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            StackTraceElement caller = new Exception().getStackTrace()[1];
            LOGGER.logp(Level.FINE, caller.getClassName(), caller.getMethodName(), actionMessage);
        }
        return include;
    }

    public String toString() {
        return String.format("%s@%h-include::%s::-exclude::%s::]", this.getClass().getSimpleName(), System.identityHashCode(this), this.patternInclude.pattern(), this.patternExclude.pattern());
    }
}

