/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import sf.util.Utility;

public class OraclePreExecutable
extends BaseExecutable {
    private static final Logger LOGGER = Logger.getLogger(OraclePreExecutable.class.getName());

    protected OraclePreExecutable() {
        super(OraclePreExecutable.class.getSimpleName());
    }

    public void execute(Connection connection) throws Exception {
        this.executeScript("/schemacrawler-oracle.before.sql", connection);
        SchemaTextOptions schemaTextOptions = new SchemaTextOptions(this.additionalConfiguration);
        if (schemaTextOptions.isShowUnqualifiedNames()) {
            this.executeScript("/schemacrawler-oracle.show_unqualified_names.sql", connection);
        }
    }

    private void executeScript(String scriptResource, Connection connection) throws SchemaCrawlerException {
        try (Statement statement = connection.createStatement();){
            String sqlScript = Utility.readResourceFully((String)scriptResource);
            if (!Utility.isBlank((String)sqlScript)) {
                for (String sql : sqlScript.split(";")) {
                    if (Utility.isBlank((String)sql)) continue;
                    statement.executeUpdate(sql);
                }
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }
}

