/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.Writer;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import schemacrawler.schema.Database;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.options.OutputWriter;

public final class FreeMarkerRenderer
extends BaseStagedExecutable {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(FreeMarkerRenderer.class.getName());
    static final String COMMAND = "freemarker";

    public FreeMarkerRenderer() {
        super(COMMAND);
    }

    protected final void executeOn(Database database, Connection connection) throws Exception {
        String templateLocation = this.outputOptions.getOutputFormatValue();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        Logger.selectLoggerLibrary((int)1);
        Configuration cfg = new Configuration();
        ClassTemplateLoader ctl = new ClassTemplateLoader(FreeMarkerRenderer.class, "/");
        FileTemplateLoader ftl = new FileTemplateLoader(new File(templatePath));
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ctl, ftl});
        cfg.setTemplateLoader((TemplateLoader)mtl);
        cfg.setEncoding(Locale.getDefault(), this.outputOptions.getInputCharset().name());
        cfg.setStrictSyntaxMode(true);
        cfg.setWhitespaceStripping(true);
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        LOGGER.log(Level.INFO, Configuration.getVersionNumber());
        LOGGER.log(Level.INFO, "FreeMarker configuration properties - " + cfg);
        HashMap<String, Database> objectMap = new HashMap<String, Database>();
        objectMap.put("database", database);
        try (OutputWriter writer = new OutputWriter(this.outputOptions);){
            Template template = cfg.getTemplate(templateLocation);
            template.process(objectMap, (Writer)writer);
        }
    }
}

