/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.File;
import java.sql.Connection;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.DatabaseWithAssociations;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.integration.graph.GraphGenerator;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.options.InfoLevel;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import sf.util.Utility;

public final class GraphExecutable
extends BaseStagedExecutable {
    static final String COMMAND = "graph";
    private GraphOptions graphOptions;

    public GraphExecutable() {
        super(COMMAND);
    }

    public final GraphOptions getGraphOptions() {
        GraphOptions graphOptions = this.graphOptions == null ? new GraphOptions(this.additionalConfiguration) : this.graphOptions;
        return graphOptions;
    }

    public final void setGraphOptions(GraphOptions graphOptions) {
        this.graphOptions = graphOptions;
    }

    @Override
    protected void executeOn(Database db, Connection connection) throws Exception {
        InfoLevel infoLevel;
        try {
            infoLevel = InfoLevel.valueOf(this.getSchemaCrawlerOptions().getSchemaInfoLevel().getTag());
        }
        catch (Exception e) {
            infoLevel = InfoLevel.unknown;
        }
        Object database = infoLevel == InfoLevel.maximum ? new DatabaseWithAssociations(db) : db;
        File dotFile = File.createTempFile("schemacrawler.", ".dot");
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFile);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setDatabase((Database)database);
        traverser.setHandler(formatter);
        traverser.traverse();
        GraphOptions graphOptions = this.getGraphOptions();
        GraphGenerator dot = new GraphGenerator(graphOptions.getGraphVizOpts(), dotFile, this.outputOptions.getOutputFormatValue(), this.outputOptions.getOutputFile());
        try {
            dot.generateDiagram();
        }
        catch (Exception e) {
            System.out.println(Utility.readResourceFully((String)"/dot.error.txt"));
            throw e;
        }
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(File dotFile) throws SchemaCrawlerException {
        GraphOptions graphOptions = this.getGraphOptions();
        SchemaTextDetailType schemaTextDetailType = graphOptions.getSchemaTextDetailType();
        SchemaDotFormatter formatter = new SchemaDotFormatter(schemaTextDetailType, graphOptions, new OutputOptions("dot", dotFile));
        return formatter;
    }
}

