/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Database;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.text.operation.Query;
import schemacrawler.tools.traversal.DataTraversalHandler;

final class OperationHelper {
    private static final Logger LOGGER = Logger.getLogger(OperationHelper.class.getName());
    private Connection connection;
    private DataTraversalHandler handler;
    private Query query;
    private Database database;

    OperationHelper() {
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getDatabase() {
        return this.database;
    }

    public DataTraversalHandler getFormatter() {
        return this.handler;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("No connection provided");
        }
        this.connection = connection;
    }

    public void setDatabase(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("No database provided");
        }
        this.database = database;
    }

    public void setFormatter(DataTraversalHandler formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("No formatter provided");
        }
        this.handler = formatter;
    }

    public void setQuery(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("No query provided");
        }
        this.query = query;
    }

    public final void traverse() throws SchemaCrawlerException {
        if (this.handler == null || this.query == null) {
            throw new SchemaCrawlerException("Cannot perform operation");
        }
        try (Statement statement = this.createStatement();){
            this.handler.begin();
            this.handler.handleInfoStart();
            this.handler.handle(this.database.getSchemaCrawlerInfo());
            this.handler.handle(this.database.getDatabaseInfo());
            this.handler.handle(this.database.getJdbcDriverInfo());
            this.handler.handleInfoEnd();
            if (this.query.isQueryOver()) {
                Collection tables = this.database.getTables();
                for (Table table : tables) {
                    String sql = this.query.getQueryForTable(table);
                    LOGGER.log(Level.FINE, String.format("Executing query for table %s: %s", table.getFullName(), sql));
                    ResultSet results = this.executeSql(statement, sql);
                    Throwable throwable = null;
                    try {
                        this.handler.handleData(table, results);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (results == null) continue;
                        if (throwable != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        results.close();
                    }
                }
            } else {
                String sql = this.query.getQuery();
                try (ResultSet results = this.executeSql(statement, sql);){
                    this.handler.handleData(this.query, results);
                }
            }
            this.handler.end();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Cannot perform operation", (Throwable)e);
        }
    }

    private Statement createStatement() throws SchemaCrawlerException, SQLException {
        if (this.connection == null) {
            throw new SchemaCrawlerException("No connection provided");
        }
        if (this.connection.isClosed()) {
            throw new SchemaCrawlerException("Connection is closed");
        }
        return this.connection.createStatement();
    }

    private ResultSet executeSql(Statement statement, String sql) throws SchemaCrawlerException {
        ResultSet results = null;
        if (statement == null) {
            return results;
        }
        try {
            boolean hasResults = statement.execute(sql);
            if (hasResults) {
                results = statement.getResultSet();
                return results;
            }
            LOGGER.log(Level.WARNING, "No results for: " + sql);
            return null;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error executing: " + sql, e);
            return null;
        }
    }
}

