/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.scripting;

import java.io.File;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.CommandChainExecutable;
import schemacrawler.tools.options.InputReader;
import schemacrawler.tools.options.OutputWriter;
import sf.util.FileUtility;
import sf.util.ObjectToString;

public final class ScriptExecutable
extends BaseExecutable {
    private static final Logger LOGGER = Logger.getLogger(ScriptExecutable.class.getName());
    static final String COMMAND = "script";

    public ScriptExecutable() {
        super(COMMAND);
    }

    @Override
    protected final void executeOn(Database database, Connection connection) throws Exception {
        String scriptFileName = this.outputOptions.getOutputFormatValue();
        File scriptFile = new File(scriptFileName);
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = scriptEngineManager.getEngineFactories();
        ScriptEngineFactory scriptEngineFactory = null;
        ScriptEngineFactory javaScriptEngineFactory = null;
        for (ScriptEngineFactory engineFactory : engineFactories) {
            LOGGER.log(Level.FINER, String.format("Evaluating script engine: %s %s (%s %s)", engineFactory.getEngineName(), engineFactory.getEngineVersion(), engineFactory.getLanguageName(), engineFactory.getLanguageVersion()));
            List<String> extensions = engineFactory.getExtensions();
            if (extensions.contains(FileUtility.getFileExtension((File)scriptFile))) {
                scriptEngineFactory = engineFactory;
                break;
            }
            if (!engineFactory.getLanguageName().equalsIgnoreCase("JavaScript")) continue;
            javaScriptEngineFactory = engineFactory;
        }
        if (scriptEngineFactory == null) {
            scriptEngineFactory = javaScriptEngineFactory;
        }
        if (scriptEngineFactory == null) {
            throw new SchemaCrawlerException("Script engine not found");
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, String.format("Using script engine%n%s %s (%s %s)%nScript engine names: %s%nSupported file extensions: %s", scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), ObjectToString.toString(scriptEngineFactory.getNames()), ObjectToString.toString(scriptEngineFactory.getExtensions())));
        }
        ScriptEngine scriptEngine = scriptEngineFactory.getScriptEngine();
        CommandChainExecutable chain = new CommandChainExecutable();
        try (InputReader reader = new InputReader(this.outputOptions);
             OutputWriter writer = new OutputWriter(this.outputOptions);){
            scriptEngine.getContext().setWriter(writer);
            scriptEngine.put("database", database);
            scriptEngine.put("connection", connection);
            scriptEngine.put("chain", chain);
            if (scriptEngine instanceof Compilable) {
                CompiledScript script = ((Compilable)((Object)scriptEngine)).compile(reader);
                script.eval();
            } else {
                scriptEngine.eval(reader);
            }
        }
    }
}

