/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.scripting.ScriptExecutable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;

public class InputReader
extends Reader {
    private static final Logger LOGGER = Logger.getLogger(InputReader.class.getName());
    private final Reader reader;
    private boolean isClosed;
    private boolean isFileOutput;

    public InputReader(OutputOptions outputOptions) throws SchemaCrawlerException {
        this.reader = this.openInputReader(outputOptions);
    }

    @Override
    public void close() throws IOException {
        this.ensureOpen();
        if (this.isFileOutput) {
            if (this.reader != null) {
                this.reader.close();
                LOGGER.log(Level.INFO, "Closed input reader");
            }
        } else {
            LOGGER.log(Level.INFO, "Not closing input reader, since input is not from a file");
        }
        this.isClosed = true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.ensureOpen();
        this.reader.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.ensureOpen();
        return this.reader.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.ensureOpen();
        return this.reader.read(target);
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.reader.skip(n);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed) {
            throw new IllegalStateException("Input reader was not closed");
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("Reader has already been closed");
        }
    }

    private Reader openInputReader(OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            InputStream inputStream;
            String scriptFileName = outputOptions.getOutputFormatValue();
            if (outputOptions.getOutputFormat() == OutputFormat.text) {
                throw new SchemaCrawlerException("No script file provided");
            }
            File scriptFile = new File(scriptFileName);
            if (scriptFile.exists() && scriptFile.canRead()) {
                inputStream = new FileInputStream(scriptFile);
            } else {
                inputStream = ScriptExecutable.class.getResourceAsStream("/" + scriptFileName);
                if (inputStream == null) {
                    throw new SchemaCrawlerException("Cannot load script, " + scriptFileName);
                }
            }
            InputStreamReader reader = new InputStreamReader(inputStream, outputOptions.getInputCharset());
            return reader;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not obtain input reader", (Throwable)e);
        }
    }
}

