/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import schemacrawler.schema.NamedObject;
import sf.util.ObjectToString;
import sf.util.Utility;

class NamedObjectList<N extends NamedObject>
implements Serializable,
Iterable<N> {
    private static final long serialVersionUID = 3257847666804142128L;
    private final Map<String, N> objects = new HashMap<String, N>();

    NamedObjectList() {
    }

    private static String makeLookupKey(NamedObject namedObject) {
        String key = namedObject == null ? null : namedObject.getLookupKey();
        return key;
    }

    private static String makeLookupKey(NamedObject namedObject, String name) {
        StringBuilder buffer = new StringBuilder(256);
        String namedObjectLookupKey = NamedObjectList.makeLookupKey(namedObject);
        if (namedObjectLookupKey != null) {
            buffer.append(namedObjectLookupKey);
        }
        if (buffer.length() > 0) {
            buffer.append('.');
        }
        buffer.append(name);
        String key = buffer.toString();
        return key;
    }

    private static String makeLookupKey(String fullName) {
        String key = Utility.isBlank(fullName) ? null : fullName;
        return key;
    }

    @Override
    public Iterator<N> iterator() {
        return this.values().iterator();
    }

    public String toString() {
        return ObjectToString.toString(this.values());
    }

    void add(N namedObject) {
        if (namedObject == null) {
            throw new IllegalArgumentException("Cannot add a null object to the list");
        }
        String key = NamedObjectList.makeLookupKey(namedObject);
        this.objects.put(key, namedObject);
    }

    boolean contains(N namedObject) {
        return this.objects.containsKey(NamedObjectList.makeLookupKey(namedObject));
    }

    N lookup(NamedObject namedObject, String name) {
        String key = NamedObjectList.makeLookupKey(namedObject, name);
        return (N)((NamedObject)this.objects.get(key));
    }

    N lookup(String fullName) {
        String key = NamedObjectList.makeLookupKey(fullName);
        return (N)((NamedObject)this.objects.get(key));
    }

    N remove(N namedObject) {
        return (N)((NamedObject)this.objects.remove(NamedObjectList.makeLookupKey(namedObject)));
    }

    N remove(String fullName) {
        return (N)((NamedObject)this.objects.remove(NamedObjectList.makeLookupKey(fullName)));
    }

    int size() {
        return this.objects.size();
    }

    List<N> values() {
        ArrayList<N> all = new ArrayList<N>(this.objects.values());
        Collections.sort(all);
        return all;
    }
}

