/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schemacrawler.InformationSchemaViews;

final class RoutineExRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(RoutineExRetriever.class.getName());

    RoutineExRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveRoutineInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasRoutinesSql()) {
            LOGGER.log(Level.FINE, "Routine definition SQL statement was not provided");
            return;
        }
        String routineDefinitionsSql = informationSchemaViews.getRoutinesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(routineDefinitionsSql));){
            while (results.next()) {
                String specificName;
                String routineName;
                String schemaName;
                String catalogName = this.quotedName(results.getString("ROUTINE_CATALOG"));
                MutableRoutine routine = this.lookupRoutine(catalogName, schemaName = this.quotedName(results.getString("ROUTINE_SCHEMA")), routineName = this.quotedName(results.getString("ROUTINE_NAME")), specificName = this.quotedName(results.getString("SPECIFIC_NAME")));
                if (routine == null) continue;
                LOGGER.log(Level.FINER, "Retrieving routine information: " + routineName);
                RoutineBodyType routineBodyType = results.getEnum("ROUTINE_BODY", RoutineBodyType.unknown);
                String definition = results.getString("ROUTINE_DEFINITION");
                routine.setRoutineBodyType(routineBodyType);
                routine.appendDefinition(definition);
                routine.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve routines", e);
        }
    }
}

