/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schema.Column;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schemacrawler.InformationSchemaViews;

final class TableExRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableExRetriever.class.getName());

    TableExRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveAdditionalColumnAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasAdditionalColumnAttributesSql()) {
            LOGGER.log(Level.FINE, "Additional column attributes SQL statement was not provided");
            return;
        }
        String columnAttributesSql = informationSchemaViews.getAdditionalColumnAttributesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(columnAttributesSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("TABLE_CATALOG"));
                String schemaName = this.quotedName(results.getString("TABLE_SCHEMA"));
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                LOGGER.log(Level.FINER, "Retrieving additional column attributes: " + columnName);
                MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                MutableColumn column = table.getColumn(columnName);
                if (column == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find column, %s.%s.%s.%s", catalogName, schemaName, tableName, columnName));
                    continue;
                }
                column.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column attributes", e);
        }
    }

    void retrieveAdditionalTableAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasAdditionalTableAttributesSql()) {
            LOGGER.log(Level.FINE, "Additional table attributes SQL statement was not provided");
            return;
        }
        String tableAttributesSql = informationSchemaViews.getAdditionalTableAttributesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(tableAttributesSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("TABLE_CATALOG"));
                String schemaName = this.quotedName(results.getString("TABLE_SCHEMA"));
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                LOGGER.log(Level.FINER, "Retrieving additional table attributes: " + tableName);
                MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                table.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional table attributes", e);
        }
    }

    void retrieveIndexInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasIndexesExtSql()) {
            LOGGER.log(Level.FINE, "Indexes information SQL statement was not provided");
            return;
        }
        String extIndexesInformationSql = informationSchemaViews.getExtIndexesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(extIndexesInformationSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("INDEX_CATALOG"));
                String schemaName = this.quotedName(results.getString("INDEX_SCHEMA"));
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                String indexName = this.quotedName(results.getString("INDEX_NAME"));
                MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, indexName));
                    continue;
                }
                LOGGER.log(Level.FINER, "Retrieving index information: " + indexName);
                MutableIndex index = table.getIndex(indexName);
                if (index == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find index, %s.%s.%s.%s", catalogName, schemaName, tableName, indexName));
                    continue;
                }
                String definition = results.getString("INDEX_DEFINITION");
                index.appendDefinition(definition);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve index information", e);
        }
    }

    void retrieveTableColumnPrivileges() throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getColumnPrivileges(null, null, "%", "%"));){
            this.createPrivileges(results, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table column privileges:" + e.getMessage());
        }
    }

    void retrieveTableConstraintInformation() throws SQLException {
        HashMap<String, MutableTableConstraint> tableConstraintsMap = new HashMap<String, MutableTableConstraint>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        Connection connection = this.getDatabaseConnection();
        this.createTableConstraints(connection, tableConstraintsMap, informationSchemaViews);
        if (!tableConstraintsMap.isEmpty()) {
            this.getTableConstraintsColumns(connection, tableConstraintsMap, informationSchemaViews);
            this.getTableConstraintsDefinitions(connection, tableConstraintsMap, informationSchemaViews);
        }
    }

    void retrieveTablePrivileges() throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTablePrivileges(null, null, "%"));){
            this.createPrivileges(results, false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table privileges", e);
        }
    }

    void retrieveTriggerInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTriggerSql()) {
            LOGGER.log(Level.FINE, "Trigger definition SQL statement was not provided");
            return;
        }
        String triggerInformationSql = informationSchemaViews.getTriggersSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(triggerInformationSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("TRIGGER_CATALOG"));
                String schemaName = this.quotedName(results.getString("TRIGGER_SCHEMA"));
                String triggerName = this.quotedName(results.getString("TRIGGER_NAME"));
                LOGGER.log(Level.FINER, "Retrieving trigger: " + triggerName);
                String tableName = results.getString("EVENT_OBJECT_TABLE");
                MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                EventManipulationType eventManipulationType = results.getEnum("EVENT_MANIPULATION", EventManipulationType.unknown);
                int actionOrder = results.getInt("ACTION_ORDER", 0);
                String actionCondition = results.getString("ACTION_CONDITION");
                String actionStatement = results.getString("ACTION_STATEMENT");
                ActionOrientationType actionOrientation = results.getEnum("ACTION_ORIENTATION", ActionOrientationType.unknown);
                String conditionTimingString = results.getString("ACTION_TIMING");
                if (conditionTimingString == null) {
                    conditionTimingString = results.getString("CONDITION_TIMING");
                }
                ConditionTimingType conditionTiming = ConditionTimingType.valueOfFromValue(conditionTimingString);
                MutableTrigger trigger = table.lookupTrigger(triggerName);
                if (trigger == null) {
                    trigger = new MutableTrigger(table, triggerName);
                }
                trigger.setEventManipulationType(eventManipulationType);
                trigger.setActionOrder(actionOrder);
                trigger.appendActionCondition(actionCondition);
                trigger.appendActionStatement(actionStatement);
                trigger.setActionOrientation(actionOrientation);
                trigger.setConditionTiming(conditionTiming);
                trigger.addAttributes(results.getAttributes());
                table.addTrigger(trigger);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve triggers", e);
        }
    }

    void retrieveViewInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasViewsSql()) {
            LOGGER.log(Level.FINE, "Views SQL statement was not provided");
            return;
        }
        String viewInformationSql = informationSchemaViews.getViewsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(viewInformationSql));){
            while (results.next()) {
                String viewName;
                String schemaName;
                String catalogName = this.quotedName(results.getString("TABLE_CATALOG"));
                MutableView view = (MutableView)this.lookupTable(catalogName, schemaName = this.quotedName(results.getString("TABLE_SCHEMA")), viewName = this.quotedName(results.getString("TABLE_NAME")));
                if (view == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, viewName));
                    continue;
                }
                LOGGER.log(Level.FINER, "Retrieving view information: " + viewName);
                String definition = results.getString("VIEW_DEFINITION");
                CheckOptionType checkOption = results.getEnum("CHECK_OPTION", CheckOptionType.unknown);
                boolean updatable = results.getBoolean("IS_UPDATABLE");
                view.appendDefinition(definition);
                view.setCheckOption(checkOption);
                view.setUpdatable(updatable);
                view.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve views", e);
        }
    }

    private void createPrivileges(MetadataResultSet results, boolean privilegesForColumn) throws SQLException {
        while (results.next()) {
            MutablePrivilege<Column> privilege;
            String catalogName = this.quotedName(results.getString("TABLE_CAT"));
            String schemaName = this.quotedName(results.getString("TABLE_SCHEM"));
            String tableName = this.quotedName(results.getString("TABLE_NAME"));
            String columnName = privilegesForColumn ? this.quotedName(results.getString("COLUMN_NAME")) : null;
            MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
            if (table == null) continue;
            MutableColumn column = table.getColumn(columnName);
            if (privilegesForColumn && column == null) continue;
            String privilegeName = results.getString("PRIVILEGE");
            String grantor = results.getString("GRANTOR");
            String grantee = results.getString("GRANTEE");
            boolean isGrantable = results.getBoolean("IS_GRANTABLE");
            if (privilegesForColumn) {
                MutablePrivilege<MutableColumn> columnPrivilege = column.getPrivilege(privilegeName);
                if (columnPrivilege == null) {
                    privilege = new MutablePrivilege<MutableColumn>(column, privilegeName);
                    column.addPrivilege(privilege);
                } else {
                    privilege = columnPrivilege;
                }
            } else {
                Privilege tablePrivilege = table.getPrivilege(privilegeName);
                if (tablePrivilege == null) {
                    privilege = new MutablePrivilege<MutableTable>(table, privilegeName);
                    table.addPrivilege(privilege);
                } else {
                    privilege = tablePrivilege;
                }
            }
            privilege.addGrant(grantor, grantee, isGrantable);
            privilege.addAttributes(results.getAttributes());
            if (privilegesForColumn) {
                column.addPrivilege(privilege);
                continue;
            }
            table.addPrivilege(privilege);
        }
    }

    private void createTableConstraints(Connection connection, Map<String, MutableTableConstraint> tableConstraintsMap, InformationSchemaViews informationSchemaViews) {
        if (!informationSchemaViews.hasTableConstraintsSql()) {
            LOGGER.log(Level.FINE, "Table constraints SQL statement was not provided");
            return;
        }
        String tableConstraintsInformationSql = informationSchemaViews.getTableConstraintsSql();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(tableConstraintsInformationSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.quotedName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = this.quotedName(results.getString("CONSTRAINT_NAME"));
                LOGGER.log(Level.FINER, "Retrieving constraint: " + constraintName);
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                String constraintType = results.getString("CONSTRAINT_TYPE");
                boolean deferrable = results.getBoolean("IS_DEFERRABLE");
                boolean initiallyDeferred = results.getBoolean("INITIALLY_DEFERRED");
                MutableTableConstraint tableConstraint = new MutableTableConstraint(table, constraintName);
                tableConstraint.setTableConstraintType(TableConstraintType.valueOfFromValue(constraintType));
                tableConstraint.setDeferrable(deferrable);
                tableConstraint.setInitiallyDeferred(initiallyDeferred);
                tableConstraint.addAttributes(results.getAttributes());
                table.addTableConstraint(tableConstraint);
                String constraintKey = table.getSchema().getFullName() + "." + constraintName;
                tableConstraintsMap.put(constraintKey, tableConstraint);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table constraint information", e);
            return;
        }
    }

    private void getTableConstraintsColumns(Connection connection, Map<String, MutableTableConstraint> tableConstraintsMap, InformationSchemaViews informationSchemaViews) {
        if (!informationSchemaViews.hasTableConstraintsColumnsSql()) {
            LOGGER.log(Level.FINE, "Extended table constraints columns SQL statement was not provided");
            return;
        }
        String tableConstraintsColumnsInformationSql = informationSchemaViews.getTableConstraintsColumnsSql();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(tableConstraintsColumnsInformationSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.quotedName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = this.quotedName(results.getString("CONSTRAINT_NAME"));
                LOGGER.log(Level.FINER, "Retrieving constraint definition: " + constraintName);
                String constraintKey = new SchemaReference(catalogName, schemaName) + "." + constraintName;
                MutableTableConstraint tableConstraint = tableConstraintsMap.get(constraintKey);
                if (tableConstraint == null) {
                    LOGGER.log(Level.FINEST, "Could not add column for constraint to table: " + constraintName);
                    continue;
                }
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                MutableColumn column = table.getColumn(columnName);
                if (column == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find column, %s.%s.%s.%s", catalogName, schemaName, tableName, columnName));
                    continue;
                }
                int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
                MutableTableConstraintColumn constraintColumn = new MutableTableConstraintColumn(tableConstraint, column);
                constraintColumn.setTableConstraintOrdinalPosition(ordinalPosition);
                tableConstraint.addColumn(constraintColumn);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", e);
        }
    }

    private void getTableConstraintsDefinitions(Connection connection, Map<String, MutableTableConstraint> tableConstraintsMap, InformationSchemaViews informationSchemaViews) {
        if (!informationSchemaViews.hasExtTableConstraintsSql()) {
            LOGGER.log(Level.FINE, "Extended table constraints SQL statement was not provided");
            return;
        }
        String extTableConstraintInformationSql = informationSchemaViews.getExtTableConstraintsSql();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(extTableConstraintInformationSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.quotedName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = this.quotedName(results.getString("CONSTRAINT_NAME"));
                LOGGER.log(Level.FINER, "Retrieving constraint definition: " + constraintName);
                String definition = results.getString("CHECK_CLAUSE");
                String constraintKey = new SchemaReference(catalogName, schemaName) + "." + constraintName;
                MutableTableConstraint tableConstraint = tableConstraintsMap.get(constraintKey);
                if (tableConstraint == null) {
                    LOGGER.log(Level.FINEST, "Could not add constraint definition to table: " + constraintName);
                    continue;
                }
                tableConstraint.appendDefinition(definition);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", e);
        }
    }
}

