/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum ForeignKeyDeferrability {
    unknown(-1, "unknown"),
    initiallyDeferred(5, "initially deferred"),
    initiallyImmediate(6, "initially immediate"),
    keyNotDeferrable(7, "not deferrable");

    private static final Logger LOGGER;
    private final int id;
    private final String text;

    public static ForeignKeyDeferrability valueOf(int id) {
        for (ForeignKeyDeferrability fkDeferrability : ForeignKeyDeferrability.values()) {
            if (fkDeferrability.getId() != id) continue;
            return fkDeferrability;
        }
        LOGGER.log(Level.FINE, "Unknown id " + id);
        return unknown;
    }

    private ForeignKeyDeferrability(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.text;
    }

    static {
        LOGGER = Logger.getLogger(ForeignKeyDeferrability.class.getName());
    }
}

