/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.RegularExpressionRule;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import sf.util.ObjectToString;

public final class SchemaCrawlerOptions
implements Options {
    private static final long serialVersionUID = -3557794862382066029L;
    private static final String SC_SCHEMA_PATTERN_EXCLUDE = "schemacrawler.schema.pattern.exclude";
    private static final String SC_SCHEMA_PATTERN_INCLUDE = "schemacrawler.schema.pattern.include";
    private static final String SC_COLUMN_PATTERN_EXCLUDE = "schemacrawler.column.pattern.exclude";
    private static final String SC_COLUMN_PATTERN_INCLUDE = "schemacrawler.column.pattern.include";
    private static final String SC_TABLE_PATTERN_EXCLUDE = "schemacrawler.table.pattern.exclude";
    private static final String SC_TABLE_PATTERN_INCLUDE = "schemacrawler.table.pattern.include";
    private static final String SC_ROUTINE_COLUMN_PATTERN_EXCLUDE = "schemacrawler.routine.inout.pattern.exclude";
    private static final String SC_ROUTINE_COLUMN_PATTERN_INCLUDE = "schemacrawler.routine.inout.pattern.include";
    private static final String SC_ROUTINE_PATTERN_EXCLUDE = "schemacrawler.routine.pattern.exclude";
    private static final String SC_ROUTINE_PATTERN_INCLUDE = "schemacrawler.routine.pattern.include";
    private static final String SC_GREP_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.column.pattern.exclude";
    private static final String SC_GREP_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.column.pattern.include";
    private static final String SC_GREP_ROUTINE_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.routine.inout.pattern.exclude";
    private static final String SC_GREP_ROUTINE_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.routine.inout.pattern.include";
    private static final String SC_GREP_DEFINITION_PATTERN_EXCLUDE = "schemacrawler.grep.definition.pattern.exclude";
    private static final String SC_GREP_DEFINITION_PATTERN_INCLUDE = "schemacrawler.grep.definition.pattern.include";
    private static final String SC_GREP_INVERT_MATCH = "schemacrawler.grep.invert-match";
    private static final String SC_GREP_ONLY_MATCHING = "schemacrawler.grep.only-matching";
    private InclusionRule schemaInclusionRule;
    private Collection<String> tableTypes;
    private String tableNamePattern;
    private InclusionRule tableInclusionRule;
    private InclusionRule columnInclusionRule;
    private Collection<RoutineType> routineTypes;
    private InclusionRule routineInclusionRule;
    private InclusionRule routineColumnInclusionRule;
    private InclusionRule synonymInclusionRule;
    private InclusionRule grepColumnInclusionRule;
    private InclusionRule grepRoutineColumnInclusionRule;
    private InclusionRule grepDefinitionInclusionRule;
    private boolean grepInvertMatch;
    private boolean grepOnlyMatching;
    private int childTableFilterDepth;
    private int parentTableFilterDepth;
    private SchemaInfoLevel schemaInfoLevel;
    private InformationSchemaViews informationSchemaViews = new InformationSchemaViews();
    private DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions = new DatabaseSpecificOverrideOptions();

    public SchemaCrawlerOptions() {
        this.schemaInclusionRule = new IncludeAll();
        this.tableTypes = new HashSet<String>(Arrays.asList("TABLE", "VIEW"));
        this.tableInclusionRule = new IncludeAll();
        this.columnInclusionRule = new IncludeAll();
        this.routineTypes = new HashSet<RoutineType>(Arrays.asList(RoutineType.procedure, RoutineType.function));
        this.routineInclusionRule = new IncludeAll();
        this.routineColumnInclusionRule = new IncludeAll();
        this.synonymInclusionRule = new IncludeAll();
    }

    public SchemaCrawlerOptions(Config config) {
        this();
        Config configProperties = config == null ? new Config() : config;
        this.informationSchemaViews = new InformationSchemaViews(config);
        this.databaseSpecificOverrideOptions = new DatabaseSpecificOverrideOptions(config);
        this.schemaInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_SCHEMA_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_SCHEMA_PATTERN_EXCLUDE, null));
        this.tableInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_TABLE_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_TABLE_PATTERN_EXCLUDE, null));
        this.columnInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_COLUMN_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_COLUMN_PATTERN_EXCLUDE, null));
        this.routineInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_ROUTINE_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_ROUTINE_PATTERN_EXCLUDE, null));
        this.routineColumnInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_ROUTINE_COLUMN_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_ROUTINE_COLUMN_PATTERN_EXCLUDE, null));
        this.grepColumnInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_GREP_COLUMN_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_GREP_COLUMN_PATTERN_EXCLUDE, null));
        this.grepRoutineColumnInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_GREP_ROUTINE_COLUMN_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_GREP_ROUTINE_COLUMN_PATTERN_EXCLUDE, null));
        this.grepDefinitionInclusionRule = new RegularExpressionRule(configProperties.getStringValue(SC_GREP_DEFINITION_PATTERN_INCLUDE, null), configProperties.getStringValue(SC_GREP_DEFINITION_PATTERN_EXCLUDE, null));
        this.grepInvertMatch = configProperties.getBooleanValue(SC_GREP_INVERT_MATCH);
        this.grepOnlyMatching = configProperties.getBooleanValue(SC_GREP_ONLY_MATCHING);
    }

    public int getChildTableFilterDepth() {
        return this.childTableFilterDepth;
    }

    public InclusionRule getColumnInclusionRule() {
        return this.columnInclusionRule;
    }

    public DatabaseSpecificOverrideOptions getDatabaseSpecificOverrideOptions() {
        return this.databaseSpecificOverrideOptions;
    }

    public InclusionRule getGrepColumnInclusionRule() {
        return this.grepColumnInclusionRule;
    }

    public InclusionRule getGrepDefinitionInclusionRule() {
        return this.grepDefinitionInclusionRule;
    }

    public InclusionRule getGrepRoutineColumnInclusionRule() {
        return this.grepRoutineColumnInclusionRule;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    public int getParentTableFilterDepth() {
        return this.parentTableFilterDepth;
    }

    public InclusionRule getRoutineColumnInclusionRule() {
        return this.routineColumnInclusionRule;
    }

    public InclusionRule getRoutineInclusionRule() {
        return this.routineInclusionRule;
    }

    public Collection<RoutineType> getRoutineTypes() {
        return new HashSet<RoutineType>(this.routineTypes);
    }

    public InclusionRule getSchemaInclusionRule() {
        return this.schemaInclusionRule;
    }

    public SchemaInfoLevel getSchemaInfoLevel() {
        if (this.schemaInfoLevel == null) {
            return SchemaInfoLevel.standard();
        }
        return this.schemaInfoLevel;
    }

    public InclusionRule getSynonymInclusionRule() {
        return this.synonymInclusionRule;
    }

    public InclusionRule getTableInclusionRule() {
        return this.tableInclusionRule;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public Collection<String> getTableTypes() {
        if (this.tableTypes == null) {
            return null;
        }
        return new HashSet<String>(this.tableTypes);
    }

    public boolean isGrepColumns() {
        return this.grepColumnInclusionRule != null;
    }

    public boolean isGrepDefinitions() {
        return this.grepDefinitionInclusionRule != null;
    }

    public boolean isGrepInvertMatch() {
        return this.grepInvertMatch;
    }

    public boolean isGrepOnlyMatching() {
        return this.grepOnlyMatching;
    }

    public boolean isGrepRoutineColumns() {
        return this.grepRoutineColumnInclusionRule != null;
    }

    public void setChildTableFilterDepth(int childTableFilterDepth) {
        this.childTableFilterDepth = childTableFilterDepth;
    }

    public void setColumnInclusionRule(InclusionRule columnInclusionRule) {
        if (columnInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.columnInclusionRule = columnInclusionRule;
    }

    public void setDatabaseSpecificOverrideOptions(DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) {
        this.databaseSpecificOverrideOptions = databaseSpecificOverrideOptions == null ? new DatabaseSpecificOverrideOptions() : databaseSpecificOverrideOptions;
    }

    public void setGrepColumnInclusionRule(InclusionRule grepColumnInclusionRule) {
        this.grepColumnInclusionRule = grepColumnInclusionRule;
    }

    public void setGrepDefinitionInclusionRule(InclusionRule grepDefinitionInclusionRule) {
        this.grepDefinitionInclusionRule = grepDefinitionInclusionRule;
    }

    public void setGrepInvertMatch(boolean grepInvertMatch) {
        this.grepInvertMatch = grepInvertMatch;
    }

    public void setGrepOnlyMatching(boolean grepOnlyMatching) {
        this.grepOnlyMatching = grepOnlyMatching;
    }

    public void setGrepRoutineColumnInclusionRule(InclusionRule grepRoutineColumnInclusionRule) {
        this.grepRoutineColumnInclusionRule = grepRoutineColumnInclusionRule;
    }

    public void setInformationSchemaViews(InformationSchemaViews informationSchemaViews) {
        this.informationSchemaViews = informationSchemaViews == null ? new InformationSchemaViews() : informationSchemaViews;
    }

    public void setParentTableFilterDepth(int parentTableFilterDepth) {
        this.parentTableFilterDepth = parentTableFilterDepth;
    }

    public void setRoutineColumnInclusionRule(InclusionRule routineColumnInclusionRule) {
        if (routineColumnInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.routineColumnInclusionRule = routineColumnInclusionRule;
    }

    public void setRoutineInclusionRule(InclusionRule routineInclusionRule) {
        if (routineInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.routineInclusionRule = routineInclusionRule;
    }

    public void setRoutineTypes(Collection<RoutineType> routineTypes) {
        this.routineTypes = routineTypes == null ? Collections.emptySet() : new HashSet<RoutineType>(routineTypes);
    }

    public void setRoutineTypes(String routineTypesString) {
        String[] routineTypeStrings;
        this.routineTypes = new HashSet<RoutineType>();
        if (routineTypesString != null && (routineTypeStrings = routineTypesString.split(",")) != null && routineTypeStrings.length > 0) {
            for (String routineTypeString : routineTypeStrings) {
                this.routineTypes.add(RoutineType.valueOf(routineTypeString.toLowerCase(Locale.ENGLISH)));
            }
        }
    }

    public void setSchemaInclusionRule(InclusionRule schemaInclusionRule) {
        if (schemaInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.schemaInclusionRule = schemaInclusionRule;
    }

    public void setSchemaInfoLevel(SchemaInfoLevel schemaInfoLevel) {
        this.schemaInfoLevel = schemaInfoLevel;
    }

    public void setSynonymInclusionRule(InclusionRule synonymInclusionRule) {
        if (synonymInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.synonymInclusionRule = synonymInclusionRule;
    }

    public void setTableInclusionRule(InclusionRule tableInclusionRule) {
        if (tableInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.tableInclusionRule = tableInclusionRule;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTableTypes(Collection<String> tableTypes) {
        this.tableTypes = tableTypes == null ? null : new HashSet<String>(tableTypes);
    }

    public void setTableTypesFromString(String tableTypesString) {
        if (tableTypesString != null) {
            this.tableTypes = new HashSet<String>();
            String[] tableTypeStrings = tableTypesString.split(",");
            if (tableTypeStrings != null && tableTypeStrings.length > 0) {
                for (String tableTypeString : tableTypeStrings) {
                    this.tableTypes.add(tableTypeString.trim());
                }
            }
        } else {
            this.tableTypes = null;
        }
    }

    public String toString() {
        return ObjectToString.toString(this);
    }
}

