/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.JavaSqlType;
import sf.util.Utility;

public final class JavaSqlTypes
implements Map<Integer, JavaSqlType>,
Iterable<JavaSqlType> {
    private static final Logger LOGGER = Logger.getLogger(JavaSqlTypes.class.getName());
    private final Map<Integer, JavaSqlType> javaSqlTypeMap = JavaSqlTypes.mapJavaSqlTypes();

    private static Map<String, Integer> createJavaSqlTypesMap() {
        HashMap<String, Integer> javaSqlTypesMap = new HashMap<String, Integer>();
        for (Field field : Types.class.getFields()) {
            try {
                String javaSqlTypeName = field.getName();
                Integer javaSqlType = (Integer)field.get(null);
                javaSqlTypesMap.put(javaSqlTypeName, javaSqlType);
            }
            catch (IllegalAccessException | SecurityException e) {
                LOGGER.log(Level.WARNING, "Could not access java.sql.Types, field " + field, e);
            }
        }
        return javaSqlTypesMap;
    }

    private static JavaSqlType.JavaSqlTypeGroup groupJavaSqlType(int type) {
        JavaSqlType.JavaSqlTypeGroup typeGroup;
        switch (type) {
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.object;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.binary;
                break;
            }
            case -7: 
            case 16: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.bit;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.character;
                break;
            }
            case -8: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.id;
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.integer;
                break;
            }
            case 2004: 
            case 2005: 
            case 2011: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.large_object;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.real;
                break;
            }
            case 2006: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.reference;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.temporal;
                break;
            }
            case 70: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.url;
                break;
            }
            case 2009: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.xml;
                break;
            }
            default: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.unknown;
            }
        }
        return typeGroup;
    }

    private static Map<Integer, JavaSqlType> mapJavaSqlTypes() {
        Map<String, Integer> javaSqlTypesMap = JavaSqlTypes.createJavaSqlTypesMap();
        HashMap<Integer, JavaSqlType> javaSqlTypes = new HashMap<Integer, JavaSqlType>();
        for (Map.Entry<String, Integer> javaSqlTypesEntry : javaSqlTypesMap.entrySet()) {
            if (javaSqlTypesEntry.getKey() == null || javaSqlTypesEntry.getValue() == null) continue;
            Integer javaSqlTypeInt = javaSqlTypesEntry.getValue();
            String javaSqlTypeName = javaSqlTypesEntry.getKey();
            JavaSqlType.JavaSqlTypeGroup javaSqlTypeGroup = JavaSqlTypes.groupJavaSqlType(javaSqlTypeInt);
            JavaSqlType javaSqlType = new JavaSqlType(javaSqlTypeInt, javaSqlTypeName, javaSqlTypeGroup);
            javaSqlTypes.put(javaSqlTypeInt, javaSqlType);
        }
        return javaSqlTypes;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.javaSqlTypeMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.javaSqlTypeMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Integer, JavaSqlType>> entrySet() {
        return new HashSet<Map.Entry<Integer, JavaSqlType>>(this.javaSqlTypeMap.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this.javaSqlTypeMap.equals(o);
    }

    @Override
    public JavaSqlType get(Object key) {
        if (this.containsKey(key)) {
            return this.javaSqlTypeMap.get(key);
        }
        return JavaSqlType.UNKNOWN;
    }

    public JavaSqlType getFromJavaSqlTypeName(String typeName) {
        JavaSqlType sqlDataType = JavaSqlType.UNKNOWN;
        if (Utility.isBlank(typeName)) {
            return sqlDataType;
        }
        for (JavaSqlType javaSqlType : this.javaSqlTypeMap.values()) {
            if (!typeName.equals(javaSqlType.getJavaSqlTypeName())) continue;
            sqlDataType = javaSqlType;
            break;
        }
        return sqlDataType;
    }

    @Override
    public int hashCode() {
        return this.javaSqlTypeMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.javaSqlTypeMap.isEmpty();
    }

    @Override
    public Iterator<JavaSqlType> iterator() {
        return this.javaSqlTypeMap.values().iterator();
    }

    @Override
    public Set<Integer> keySet() {
        return new HashSet<Integer>(this.javaSqlTypeMap.keySet());
    }

    @Override
    public JavaSqlType put(Integer key, JavaSqlType value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends JavaSqlType> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaSqlType remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.javaSqlTypeMap.size();
    }

    public String toString() {
        return this.javaSqlTypeMap.toString();
    }

    @Override
    public Collection<JavaSqlType> values() {
        return new HashSet<JavaSqlType>(this.javaSqlTypeMap.values());
    }
}

