/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;

public class InputReader
extends Reader {
    private static final Logger LOGGER = Logger.getLogger(InputReader.class.getName());
    private final Reader reader;
    private boolean isClosed;
    private String description;

    public InputReader(OutputOptions outputOptions) throws SchemaCrawlerException {
        this.reader = this.openInputReader(outputOptions);
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null && !this.isClosed) {
            this.reader.close();
            LOGGER.log(Level.INFO, "Closed input reader, " + this.description);
        } else {
            LOGGER.log(Level.INFO, String.format("Input reader \"%s\" is already closed", this.description));
        }
        this.isClosed = true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.ensureOpen();
        this.reader.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.ensureOpen();
        return this.reader.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.ensureOpen();
        return this.reader.read(target);
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.reader.skip(n);
    }

    public String toString() {
        return this.description;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed) {
            throw new IllegalStateException(String.format("Input reader \"%s\" was not closed", this.description));
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException(String.format("Input reader \"%s\" has been closed", this.description));
        }
    }

    private Reader openInputReader(OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            InputStream inputStream;
            String inputSource = outputOptions.getOutputFormatValue();
            if (outputOptions.getOutputFormat() == OutputFormat.text) {
                throw new SchemaCrawlerException("No script file provided");
            }
            File inputFile = new File(inputSource);
            if (inputFile.exists() && inputFile.canRead()) {
                inputStream = new FileInputStream(inputFile);
                this.description = inputFile.getAbsolutePath();
                LOGGER.log(Level.INFO, "Reading from " + this.description);
            } else {
                String resource = "/" + inputSource;
                inputStream = InputReader.class.getResourceAsStream(resource);
                if (inputStream == null) {
                    throw new SchemaCrawlerException("Cannot load " + inputSource);
                }
                this.description = InputReader.class.getResource(resource).toExternalForm();
                LOGGER.log(Level.INFO, "Reading from " + this.description);
            }
            InputStreamReader reader = new InputStreamReader(inputStream, outputOptions.getInputCharset());
            return reader;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not obtain input reader", (Throwable)e);
        }
    }
}

