/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ExcludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.options.InfoLevel;
import sf.util.Utility;
import sf.util.clparser.BooleanOption;
import sf.util.clparser.NumberOption;
import sf.util.clparser.StringOption;

public final class SchemaCrawlerOptionsParser
extends BaseOptionsParser<SchemaCrawlerOptions> {
    private static final String DEFAULT_TABLE_TYPES = "TABLE,VIEW";
    private static final String DEFAULT_ROUTINE_TYPES = "PROCEDURE,FUNCTION";
    private final SchemaCrawlerOptions options;

    public SchemaCrawlerOptionsParser(Config config) {
        super(new StringOption("infolevel", "standard"), new StringOption("schemas", null), new StringOption("tabletypes", DEFAULT_TABLE_TYPES), new StringOption("tables", null), new StringOption("excludecolumns", null), new StringOption("synonyms", null), new StringOption("sequences", null), new StringOption("routinetypes", DEFAULT_ROUTINE_TYPES), new StringOption("routines", null), new StringOption("excludeinout", null), new StringOption("grepcolumns", null), new StringOption("grepinout", null), new StringOption("grepdef", null), new BooleanOption("invert-match"), new BooleanOption("only-matching"), new NumberOption("parents", (Number)0), new NumberOption("children", (Number)0));
        this.options = new SchemaCrawlerOptions(config);
    }

    @Override
    public SchemaCrawlerOptions getOptions() throws SchemaCrawlerException {
        if (this.hasOptionValue("infolevel")) {
            try {
                String infoLevel = this.getStringValue("infolevel");
                SchemaInfoLevel schemaInfoLevel = InfoLevel.valueOf((String)infoLevel).getSchemaInfoLevel();
                this.options.setSchemaInfoLevel(schemaInfoLevel);
            }
            catch (IllegalArgumentException e) {
                this.options.setSchemaInfoLevel(SchemaInfoLevel.standard());
            }
        } else {
            throw new SchemaCrawlerException("No infolevel specified");
        }
        if (this.hasOptionValue("schemas")) {
            RegularExpressionInclusionRule schemaInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("schemas"));
            this.options.setSchemaInclusionRule((InclusionRule)schemaInclusionRule);
        }
        if (this.hasOptionValue("tabletypes")) {
            String tabletypes = this.getStringValue("tabletypes");
            if (!Utility.isBlank((String)tabletypes)) {
                this.options.setTableTypesFromString(tabletypes);
            } else {
                this.options.setTableTypesFromString(null);
            }
        }
        if (this.hasOptionValue("tables")) {
            RegularExpressionInclusionRule tableInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("tables"));
            this.options.setTableInclusionRule((InclusionRule)tableInclusionRule);
        }
        if (this.hasOptionValue("excludecolumns")) {
            RegularExpressionExclusionRule columnInclusionRule = new RegularExpressionExclusionRule(this.getStringValue("excludecolumns"));
            this.options.setColumnInclusionRule((InclusionRule)columnInclusionRule);
        }
        if (this.hasOptionValue("routinetypes")) {
            this.options.setRoutineTypes(this.getStringValue("routinetypes"));
        }
        if (this.hasOptionValue("routines")) {
            RegularExpressionInclusionRule routineInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("routines"));
            this.options.setRoutineInclusionRule((InclusionRule)routineInclusionRule);
        }
        if (this.hasOptionValue("excludeinout")) {
            RegularExpressionExclusionRule routineColumnInclusionRule = new RegularExpressionExclusionRule(this.getStringValue("excludeinout"));
            this.options.setRoutineColumnInclusionRule((InclusionRule)routineColumnInclusionRule);
        }
        if (this.hasOptionValue("synonyms")) {
            RegularExpressionInclusionRule synonymInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("synonyms"));
            this.options.setSynonymInclusionRule((InclusionRule)synonymInclusionRule);
        } else {
            this.options.setSynonymInclusionRule((InclusionRule)new ExcludeAll());
        }
        if (this.hasOptionValue("sequences")) {
            RegularExpressionInclusionRule sequenceInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("sequences"));
            this.options.setSequenceInclusionRule((InclusionRule)sequenceInclusionRule);
        } else {
            this.options.setSequenceInclusionRule((InclusionRule)new ExcludeAll());
        }
        if (this.hasOptionValue("invert-match")) {
            this.options.setGrepInvertMatch(this.getBooleanValue("invert-match"));
        }
        if (this.hasOptionValue("only-matching")) {
            this.options.setGrepOnlyMatching(this.getBooleanValue("only-matching"));
        }
        if (this.hasOptionValue("grepcolumns")) {
            RegularExpressionInclusionRule grepColumnInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("grepcolumns"));
            this.options.setGrepColumnInclusionRule((InclusionRule)grepColumnInclusionRule);
        } else {
            this.options.setGrepColumnInclusionRule(null);
        }
        if (this.hasOptionValue("grepinout")) {
            RegularExpressionInclusionRule grepRoutineColumnInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("grepinout"));
            this.options.setGrepRoutineColumnInclusionRule((InclusionRule)grepRoutineColumnInclusionRule);
        } else {
            this.options.setGrepRoutineColumnInclusionRule(null);
        }
        if (this.hasOptionValue("grepdef")) {
            RegularExpressionInclusionRule grepDefinitionInclusionRule = new RegularExpressionInclusionRule(this.getStringValue("grepdef"));
            this.options.setGrepDefinitionInclusionRule((InclusionRule)grepDefinitionInclusionRule);
        } else {
            this.options.setGrepDefinitionInclusionRule(null);
        }
        if (this.hasOptionValue("parents")) {
            int parentTableFilterDepth = this.getIntegerValue("parents");
            this.options.setParentTableFilterDepth(parentTableFilterDepth);
        } else {
            this.options.setParentTableFilterDepth(0);
        }
        if (this.hasOptionValue("children")) {
            int childTableFilterDepth = this.getIntegerValue("children");
            this.options.setChildTableFilterDepth(childTableFilterDepth);
        } else {
            this.options.setParentTableFilterDepth(0);
        }
        return this.options;
    }
}

