/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.utility.TableCell;
import sf.util.Utility;

public final class TableRow {
    private final OutputFormat outputFormat;
    private final List<TableCell> cells;

    public TableRow(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        this.cells = new ArrayList<TableCell>();
    }

    public void add(TableCell cell) {
        this.cells.add(cell);
    }

    public TableCell firstCell() {
        if (this.cells.isEmpty()) {
            return null;
        }
        return this.cells.get(0);
    }

    public TableCell lastCell() {
        if (this.cells.isEmpty()) {
            return null;
        }
        return this.cells.get(this.cells.size() - 1);
    }

    public String toString() {
        if (this.outputFormat == OutputFormat.html) {
            return this.toHtmlString();
        }
        return this.toPlainTextString();
    }

    private String getFieldSeparator() {
        String fieldSeparator;
        switch (this.outputFormat) {
            case csv: {
                fieldSeparator = ",";
                break;
            }
            case tsv: {
                fieldSeparator = "\t";
                break;
            }
            default: {
                fieldSeparator = "  ";
            }
        }
        return fieldSeparator;
    }

    private String toHtmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\t<tr>").append(Utility.NEWLINE);
        for (TableCell cell : this.cells) {
            buffer.append("\t\t").append(cell).append(Utility.NEWLINE);
        }
        buffer.append("\t</tr>");
        return buffer.toString();
    }

    private String toPlainTextString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.cells.size(); ++i) {
            TableCell cell = this.cells.get(i);
            if (i > 0) {
                buffer.append(this.getFieldSeparator());
            }
            buffer.append(cell.toString());
        }
        return buffer.toString();
    }
}

