/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DependantObject;
import sf.util.Utility;

abstract class AbstractDependantObject
extends AbstractDatabaseObject
implements DependantObject {
    private static final long serialVersionUID = -4327208866052082457L;
    private final DatabaseObject parent;
    private transient String fullName;
    private transient int hashCode;

    AbstractDependantObject(DatabaseObject parent, String name) {
        super(parent.getSchema(), name);
        this.parent = parent;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AbstractDependantObject other = (AbstractDependantObject)obj;
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public final DatabaseObject getParent() {
        return this.parent;
    }

    @Override
    public int hashCode() {
        this.buildHashCode();
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    private void buildFullName() {
        if (this.fullName == null) {
            String quotedName;
            StringBuilder buffer = new StringBuilder();
            String parentFullName = this.parent.getFullName();
            if (this.parent != null && !Utility.isBlank(parentFullName)) {
                buffer.append(parentFullName).append('.');
            }
            if (!Utility.isBlank(quotedName = this.getName())) {
                buffer.append(quotedName);
            }
            this.fullName = buffer.toString();
        }
    }

    private void buildHashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            this.hashCode = result = 31 * result + super.hashCode();
        }
    }
}

