/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Options;
import sf.util.Utility;

final class DatabaseSystemParameters
implements Options {
    private static final long serialVersionUID = -4734554820673397484L;
    private static final Logger LOGGER = Logger.getLogger(DatabaseSystemParameters.class.getName());
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;
    private final String identifierQuoteString;
    private final List<String> reservedWords;

    DatabaseSystemParameters(Connection connection) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        this.supportsCatalogs = dbMetaData.supportsCatalogsInTableDefinitions();
        LOGGER.log(Level.CONFIG, String.format("Database %s catalogs", this.supportsCatalogs ? "supports" : "does not support"));
        this.supportsSchemas = dbMetaData.supportsSchemasInTableDefinitions();
        LOGGER.log(Level.CONFIG, String.format("Database %s schemas", this.supportsSchemas ? "supports" : "does not support"));
        this.identifierQuoteString = dbMetaData.getIdentifierQuoteString();
        HashSet<String> rawReservedWords = new HashSet<String>();
        rawReservedWords.addAll(Arrays.asList(dbMetaData.getSQLKeywords().split(",")));
        rawReservedWords.addAll(Arrays.asList(Utility.readResourceFully("/sql2003_reserved_words.txt").split("\r\n")));
        ArrayList<String> reservedWordsList = new ArrayList<String>();
        for (String reservedWord : rawReservedWords) {
            reservedWordsList.add(reservedWord.trim().toUpperCase());
        }
        Collections.sort(reservedWordsList);
        this.reservedWords = Collections.unmodifiableList(reservedWordsList);
    }

    String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }

    boolean needsToBeQuoted(String name) {
        boolean needsToBeQuoted = name != null && this.identifierQuoteString != null && (Utility.containsWhitespace(name) || this.reservedWords.contains(name.toUpperCase()));
        return needsToBeQuoted;
    }
}

