/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractColumn;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Column;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Privilege;

class MutableColumn
extends AbstractColumn
implements Column {
    private static final long serialVersionUID = 3834591019449528633L;
    private String defaultValue;
    private boolean isPartOfPrimaryKey;
    private boolean isPartOfUniqueIndex;
    private MutableColumn referencedColumn;
    private final NamedObjectList<MutablePrivilege> privileges = new NamedObjectList();

    MutableColumn(DatabaseObject parent, String name) {
        super(parent, name);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public MutablePrivilege getPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    @Override
    public Privilege[] getPrivileges() {
        return this.privileges.values().toArray(new Privilege[this.privileges.size()]);
    }

    @Override
    public Column getReferencedColumn() {
        return this.referencedColumn;
    }

    @Override
    public boolean isPartOfForeignKey() {
        return this.referencedColumn != null;
    }

    @Override
    public boolean isPartOfPrimaryKey() {
        return this.isPartOfPrimaryKey;
    }

    @Override
    public boolean isPartOfUniqueIndex() {
        return this.isPartOfUniqueIndex;
    }

    void addPrivilege(MutablePrivilege privilege) {
        this.privileges.add(privilege);
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void setPartOfPrimaryKey(boolean partOfPrimaryKey) {
        this.isPartOfPrimaryKey = partOfPrimaryKey;
    }

    void setPartOfUniqueIndex(boolean partOfUniqueIndex) {
        this.isPartOfUniqueIndex = partOfUniqueIndex;
    }

    void setReferencedColumn(MutableColumn referencedColumn) {
        this.referencedColumn = referencedColumn;
    }
}

