/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.MutableCheckConstraint;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.NamedObjectSort;
import schemacrawler.schema.CheckConstraint;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnMap;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.TableType;
import schemacrawler.schema.Trigger;

class MutableTable
extends AbstractDatabaseObject
implements Table {
    private static final long serialVersionUID = 3257290248802284852L;
    private TableType type = TableType.unknown;
    private MutablePrimaryKey primaryKey;
    private final NamedObjectList<MutableColumn> columns = new NamedObjectList();
    private final NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList();
    private final NamedObjectList<MutableIndex> indices = new NamedObjectList();
    private final NamedObjectList<MutableCheckConstraint> checkConstraints = new NamedObjectList();
    private final NamedObjectList<MutableTrigger> triggers = new NamedObjectList();
    private final NamedObjectList<MutablePrivilege> privileges = new NamedObjectList();
    private int sortIndex;

    MutableTable(Schema schema, String name) {
        super(schema, name);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        MutableTable other = (MutableTable)obj;
        int comparison = 0;
        if (comparison == 0) {
            comparison = this.sortIndex - other.sortIndex;
        }
        if (comparison == 0) {
            comparison = super.compareTo(other);
        }
        return comparison;
    }

    @Override
    public CheckConstraint[] getCheckConstraints() {
        return this.checkConstraints.values().toArray(new CheckConstraint[this.checkConstraints.size()]);
    }

    @Override
    public MutableColumn getColumn(String name) {
        return this.columns.lookup(this, name);
    }

    @Override
    public Column[] getColumns() {
        return this.columns.values().toArray(new Column[this.columns.size()]);
    }

    @Override
    public String getColumnsListAsString() {
        Column[] columnsArray = this.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < columnsArray.length; ++i) {
            Column column = columnsArray[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(column.getName());
        }
        return buffer.toString();
    }

    @Override
    public ForeignKey[] getExportedForeignKeys() {
        return this.getForeignKeys(TableAssociationType.exported);
    }

    @Override
    public MutableForeignKey getForeignKey(String name) {
        return this.foreignKeys.lookup(this, name);
    }

    @Override
    public ForeignKey[] getForeignKeys() {
        return this.getForeignKeys(TableAssociationType.all);
    }

    @Override
    public ForeignKey[] getImportedForeignKeys() {
        return this.getForeignKeys(TableAssociationType.imported);
    }

    @Override
    public MutableIndex getIndex(String name) {
        return this.indices.lookup(this, name);
    }

    @Override
    public Index[] getIndices() {
        return this.indices.values().toArray(new Index[this.indices.size()]);
    }

    @Override
    public MutablePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public MutablePrivilege getPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    @Override
    public Privilege[] getPrivileges() {
        return this.privileges.values().toArray(new Privilege[this.privileges.size()]);
    }

    @Override
    public Table[] getRelatedTables(TableRelationshipType tableRelationshipType) {
        HashSet<MutableTable> relatedTables = new HashSet<MutableTable>();
        if (tableRelationshipType != null && tableRelationshipType != TableRelationshipType.none) {
            ArrayList<MutableForeignKey> foreignKeysList = new ArrayList<MutableForeignKey>(this.foreignKeys.values());
            for (MutableForeignKey mutableForeignKey : foreignKeysList) {
                block5: for (ForeignKeyColumnMap columnPair : mutableForeignKey.getColumnPairs()) {
                    MutableTable parentTable = (MutableTable)columnPair.getPrimaryKeyColumn().getParent();
                    MutableTable childTable = (MutableTable)columnPair.getForeignKeyColumn().getParent();
                    switch (tableRelationshipType) {
                        case parent: {
                            if (!this.equals(childTable)) continue block5;
                            relatedTables.add(parentTable);
                            continue block5;
                        }
                        case child: {
                            if (!this.equals(parentTable)) continue block5;
                            relatedTables.add(childTable);
                            continue block5;
                        }
                    }
                }
            }
        }
        return relatedTables.toArray(new Table[relatedTables.size()]);
    }

    @Override
    public MutableTrigger getTrigger(String name) {
        return this.lookupTrigger(name);
    }

    @Override
    public Trigger[] getTriggers() {
        return this.triggers.values().toArray(new Trigger[this.triggers.size()]);
    }

    @Override
    public TableType getType() {
        return this.type;
    }

    void addCheckConstraint(MutableCheckConstraint checkConstraint) {
        this.checkConstraints.add(checkConstraint);
    }

    void addColumn(MutableColumn column) {
        this.columns.add(column);
    }

    void addForeignKey(MutableForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    void addIndex(MutableIndex index) {
        this.indices.add(index);
    }

    void addPrivilege(MutablePrivilege privilege) {
        this.privileges.add(privilege);
    }

    void addTrigger(MutableTrigger trigger) {
        this.triggers.add(trigger);
    }

    int getSortIndex() {
        return this.sortIndex;
    }

    MutableTrigger lookupTrigger(String triggerName) {
        return this.triggers.lookup(this, triggerName);
    }

    void replacePrimaryKey() {
        if (this.primaryKey == null) {
            return;
        }
        String primaryKeyName = this.primaryKey.getName();
        MutableIndex index = this.indices.lookup(this, primaryKeyName);
        if (index != null) {
            IndexColumn[] indexColumns;
            boolean indexHasPkColumns = false;
            IndexColumn[] pkColumns = this.primaryKey.getColumns();
            if (pkColumns.length == (indexColumns = index.getColumns()).length) {
                for (int i = 0; i < indexColumns.length && pkColumns[i].equals(indexColumns[i]); ++i) {
                }
                indexHasPkColumns = true;
            }
            if (indexHasPkColumns) {
                this.indices.remove(index);
                this.setPrimaryKey(new MutablePrimaryKey(index));
            }
        }
    }

    void setColumnsSortOrder(NamedObjectSort sort) {
        this.columns.setSortOrder(sort);
    }

    void setForeignKeysSortOrder(NamedObjectSort sort) {
        this.foreignKeys.setSortOrder(sort);
    }

    void setIndicesSortOrder(NamedObjectSort sort) {
        this.indices.setSortOrder(sort);
    }

    void setPrimaryKey(MutablePrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    void setType(TableType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null table type");
        }
        this.type = type;
    }

    private ForeignKey[] getForeignKeys(TableAssociationType tableAssociationType) {
        ArrayList<MutableForeignKey> foreignKeysList = new ArrayList<MutableForeignKey>(this.foreignKeys.values());
        if (tableAssociationType != null && tableAssociationType != TableAssociationType.all) {
            Iterator iterator = foreignKeysList.iterator();
            while (iterator.hasNext()) {
                MutableForeignKey mutableForeignKey = (MutableForeignKey)iterator.next();
                ForeignKeyColumnMap[] columnPairs = mutableForeignKey.getColumnPairs();
                boolean isExportedKey = false;
                boolean isImportedKey = false;
                for (ForeignKeyColumnMap columnPair : columnPairs) {
                    if (columnPair.getPrimaryKeyColumn().getParent().equals(this)) {
                        isExportedKey = true;
                    }
                    if (!columnPair.getForeignKeyColumn().getParent().equals(this)) continue;
                    isImportedKey = true;
                }
                switch (tableAssociationType) {
                    case exported: {
                        if (isExportedKey) break;
                        iterator.remove();
                        break;
                    }
                    case imported: {
                        if (isImportedKey) break;
                        iterator.remove();
                        break;
                    }
                }
            }
        }
        return foreignKeysList.toArray(new ForeignKey[foreignKeysList.size()]);
    }

    private static enum TableAssociationType {
        all,
        exported,
        imported;

    }
}

