/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import schemacrawler.crawl.DatabaseSystemParameters;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

final class RetrieverConnection {
    private final Connection connection;
    private final DatabaseMetaData metaData;
    private final DatabaseSystemParameters dbSystemParameters;
    private final InformationSchemaViews informationSchemaViews;

    RetrieverConnection(Connection connection, SchemaCrawlerOptions options) throws SQLException {
        SchemaCrawlerOptions schemaCrawlerOptions = options;
        if (schemaCrawlerOptions == null) {
            schemaCrawlerOptions = new SchemaCrawlerOptions();
        }
        if (connection == null) {
            throw new SQLException("No connection provided");
        }
        if (connection.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        this.connection = connection;
        this.metaData = connection.getMetaData();
        this.dbSystemParameters = new DatabaseSystemParameters(connection);
        this.informationSchemaViews = schemaCrawlerOptions.getInformationSchemaViews();
    }

    Connection getConnection() {
        return this.connection;
    }

    DatabaseSystemParameters getDatabaseSystemParameters() {
        return this.dbSystemParameters;
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    DatabaseMetaData getMetaData() {
        return this.metaData;
    }
}

