/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hsqldb.server.Server;
import schemacrawler.schema.Database;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.DatabaseConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.SchemaCrawlerUtility;
import sf.util.Utility;

public class TestDatabase {
    private static final Level DEBUG_LOG_LEVEL = Level.OFF;
    private static final Logger LOGGER = Logger.getLogger(TestDatabase.class.getName());
    private static final String serverFileStem = "hsqldb.schemacrawler";
    private DatabaseConnectionOptions connectionOptions;

    public static void initializeApplicationLogging() {
        Utility.setApplicationLogLevel(DEBUG_LOG_LEVEL);
    }

    public static void main(String[] args) throws Exception {
        final TestDatabase testDb = new TestDatabase();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                testDb.shutdownDatabase();
            }
        });
        testDb.startDatabase(false);
    }

    private static void deleteServerFiles() {
        File[] files;
        FilenameFilter serverFilesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Arrays.asList("hsqldb.schemacrawler.lck", "hsqldb.schemacrawler.log", "hsqldb.schemacrawler.lobs", "hsqldb.schemacrawler.script", "hsqldb.schemacrawler.properties").contains(name);
            }
        };
        for (File file : files = new File(".").listFiles(serverFilesFilter)) {
            boolean delete;
            if (file.isDirectory() || file.isHidden() || (delete = file.delete())) continue;
            LOGGER.log(Level.FINE, "Could not delete " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupSchema(DatabaseConnectionOptions dataSource) {
        Connection connection = null;
        Statement statement = null;
        try {
            if (dataSource != null) {
                connection = dataSource.createConnection();
                connection.setAutoCommit(true);
                statement = connection.createStatement();
                for (String schema : new String[]{"Books", "Book Sales"}) {
                    for (String scriptType : new String[]{"pre_schema", "schema", "post_schema", "data"}) {
                        String scriptResource = String.format("/%s.%s.sql", schema, scriptType).toLowerCase(Locale.ENGLISH);
                        String sqlScript = Utility.readResourceFully(scriptResource);
                        if (Utility.isBlank(sqlScript)) continue;
                        for (String sql : sqlScript.split(";")) {
                            if (Utility.isBlank(sql)) continue;
                            statement.executeUpdate(sql);
                        }
                    }
                }
                connection.close();
            }
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.WARNING, "", e);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            }
        }
    }

    public Connection getConnection() throws SchemaCrawlerException {
        return this.connectionOptions.createConnection();
    }

    public Database getDatabase(SchemaCrawlerOptions schemaCrawlerOptions) throws SchemaCrawlerException {
        Database database = SchemaCrawlerUtility.getDatabase(this.getConnection(), schemaCrawlerOptions);
        return database;
    }

    public DatabaseConnectionOptions getDatabaseConnectionOptions() {
        return this.connectionOptions;
    }

    public Schema getSchema(SchemaCrawlerOptions schemaCrawlerOptions, String schemaName) throws SchemaCrawlerException, SQLException {
        Database database = this.getDatabase(schemaCrawlerOptions);
        Schema schema = database.getSchema(schemaName);
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownDatabase() {
        Connection connection = null;
        Statement statement = null;
        try {
            if (this.connectionOptions != null) {
                connection = this.connectionOptions.createConnection();
                if (connection != null) {
                    statement = connection.createStatement();
                    statement.execute("SHUTDOWN");
                    connection.close();
                }
                this.connectionOptions = null;
            }
            TestDatabase.deleteServerFiles();
            LOGGER.log(Level.INFO, "SHUTDOWN database");
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.WARNING, "", e);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            }
        }
    }

    public void startDatabase(boolean silent) throws SchemaCrawlerException {
        LOGGER.log(Level.FINE, this.toString() + " - Setting up database");
        TestDatabase.deleteServerFiles();
        Server.main((String[])new String[]{"-database.0", serverFileStem, "-dbname.0", "schemacrawler", "-silent", Boolean.toString(silent), "-trace", Boolean.toString(!silent), "-no_system_exit", "true"});
        this.createDatabase("jdbc:hsqldb:hsql://localhost/schemacrawler");
    }

    public void startMemoryDatabase() throws SchemaCrawlerException {
        LOGGER.log(Level.FINE, this.toString() + " - Setting up in-memory database");
        this.createDatabase("jdbc:hsqldb:mem:schemacrawler");
    }

    private void createDatabase(String url) throws SchemaCrawlerException {
        this.makeDataSource(url);
        TestDatabase.setupSchema(this.connectionOptions);
    }

    private void makeDataSource(String url) throws SchemaCrawlerException {
        this.connectionOptions = new DatabaseConnectionOptions("org.hsqldb.jdbc.JDBCDriver", url);
        this.connectionOptions.setUser("sa");
        this.connectionOptions.setPassword("");
    }
}

