/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.OutputOptions;

public abstract class ExecutableChain {
    private final List<Executable> executables = new ArrayList<Executable>();
    private Database database;
    private Connection connection;

    protected ExecutableChain() {
    }

    public final Executable addNext(Executable executable) {
        this.executables.add(executable);
        return executable;
    }

    public final void execute() throws Exception {
        for (Executable executable : this.executables) {
            ((BaseExecutable)executable).executeOn(this.database, this.connection);
        }
    }

    protected Executable addNext(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfiguration, String outputFormat, File outputFile) throws SchemaCrawlerException {
        try {
            CommandRegistry commandRegistry = new CommandRegistry();
            Executable executable = commandRegistry.instantiateExecutableForCommand(command);
            OutputOptions outputOptions = new OutputOptions(outputFormat, outputFile);
            executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
            executable.setAdditionalConfiguration(additionalConfiguration);
            executable.setOutputOptions(outputOptions);
            return this.addNext(executable);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Bad command, %s - %s - %s", command, outputFormat, outputFile));
        }
    }

    protected final Connection getConnection() {
        return this.connection;
    }

    protected final Database getDatabase() {
        return this.database;
    }

    protected final void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected final void setDatabase(Database database) {
        this.database = database;
    }
}

