/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.AnalyzedDatabase;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.options.InfoLevel;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextFormatter;
import schemacrawler.tools.text.schema.SchemaTextOptions;

public final class SchemaTextExecutable
extends BaseExecutable {
    private static final long serialVersionUID = -6824567755397315920L;
    private SchemaTextOptions schemaTextOptions;

    public SchemaTextExecutable(String command) {
        super(command);
    }

    public final SchemaTextOptions getSchemaTextOptions() {
        SchemaTextOptions schemaTextOptions = this.schemaTextOptions == null ? new SchemaTextOptions(this.additionalConfiguration) : this.schemaTextOptions;
        return schemaTextOptions;
    }

    public final void setSchemaTextOptions(SchemaTextOptions schemaTextOptions) {
        this.schemaTextOptions = schemaTextOptions;
    }

    private SchemaTextFormatter getDatabaseTraversalHandler() throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = SchemaTextDetailType.schema;
        }
        SchemaTextOptions schemaTextOptions = this.getSchemaTextOptions();
        SchemaTextFormatter formatter = new SchemaTextFormatter(schemaTextDetailType, schemaTextOptions, this.outputOptions);
        return formatter;
    }

    @Override
    protected void executeOn(Database db, Connection connection) throws Exception {
        InfoLevel infoLevel;
        try {
            infoLevel = InfoLevel.valueOf(this.getSchemaCrawlerOptions().getSchemaInfoLevel().getTag());
        }
        catch (Exception e) {
            infoLevel = InfoLevel.unknown;
        }
        Database database = db;
        if (infoLevel.ordinal() >= InfoLevel.lint.ordinal()) {
            database = new AnalyzedDatabase(database, infoLevel);
        }
        SchemaTextFormatter formatter = this.getDatabaseTraversalHandler();
        formatter.begin();
        formatter.handle(database.getSchemaCrawlerInfo(), database.getDatabaseInfo(), database.getJdbcDriverInfo());
        ArrayList<ColumnDataType> columnDataTypes = new ArrayList<ColumnDataType>();
        ArrayList<Table> tables = new ArrayList<Table>();
        ArrayList<Procedure> procedures = new ArrayList<Procedure>();
        columnDataTypes.addAll(Arrays.asList(database.getSystemColumnDataTypes()));
        for (Schema schema : database.getSchemas()) {
            columnDataTypes.addAll(Arrays.asList(schema.getColumnDataTypes()));
            tables.addAll(Arrays.asList(schema.getTables()));
            procedures.addAll(Arrays.asList(schema.getProcedures()));
        }
        if (!columnDataTypes.isEmpty()) {
            formatter.handleColumnDataTypesStart();
            for (ColumnDataType columnDataType : columnDataTypes) {
                formatter.handle(columnDataType);
            }
            formatter.handleColumnDataTypesEnd();
        }
        if (!tables.isEmpty()) {
            formatter.handleTablesStart();
            for (Table table : tables) {
                formatter.handle(table);
            }
            formatter.handleTablesEnd();
        }
        if (!procedures.isEmpty()) {
            formatter.handleProceduresStart();
            for (Procedure procedure : procedures) {
                formatter.handle(procedure);
            }
            formatter.handleProceduresEnd();
        }
        formatter.end();
    }
}

