/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.io.Console;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.Version;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.tools.commandline.BaseOptionsParser;
import sf.util.clparser.StringOption;

abstract class BaseDatabaseConnectionOptionsParser
extends BaseOptionsParser<ConnectionOptions> {
    private static final Logger LOGGER = Logger.getLogger(BaseDatabaseConnectionOptionsParser.class.getName());
    protected final Config config;

    BaseDatabaseConnectionOptionsParser(Config config) {
        super(new StringOption("user", null), new StringOption("password", null));
        this.config = config;
    }

    private String promptForPassword() {
        Console console = System.console();
        if (console == null) {
            LOGGER.log(Level.WARNING, "System console is not available");
            return null;
        }
        try {
            console.format(Version.about(), new Object[0]);
            char[] passwordChars = console.readPassword("password: ", new Object[0]);
            return new String(passwordChars);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "System console is not available", e);
            return null;
        }
    }

    protected final void setPassword(ConnectionOptions connectionOptions) {
        String password = this.hasOptionValue("password") ? this.getStringValue("password") : this.promptForPassword();
        connectionOptions.setPassword(password);
    }

    protected final void setUser(ConnectionOptions connectionOptions) {
        connectionOptions.setUser(this.getStringValue("user"));
    }
}

