/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.options.InfoLevel;
import sf.util.clparser.BooleanOption;
import sf.util.clparser.StringOption;

final class SchemaCrawlerOptionsParser
extends BaseOptionsParser<SchemaCrawlerOptions> {
    private final SchemaCrawlerOptions options;

    SchemaCrawlerOptionsParser(Config config) {
        super(new StringOption("infolevel", "standard"), new StringOption("schemas", ""), new StringOption("table_types", "TABLE,VIEW"), new StringOption("tables", ".*"), new StringOption("excludecolumns", ""), new StringOption("procedures", ".*"), new StringOption("excludeinout", ""), new StringOption("grepcolumns", ""), new StringOption("grepinout", ""), new StringOption("grepdef", ""), new BooleanOption(Character.valueOf('v'), "invert-match"), new BooleanOption("sorttables"), new BooleanOption("sortcolumns"), new BooleanOption("sortinout"));
        this.options = new SchemaCrawlerOptions(config);
    }

    @Override
    protected SchemaCrawlerOptions getOptions() throws SchemaCrawlerException {
        if (this.hasOptionValue("infolevel")) {
            try {
                String infoLevel = this.getStringValue("infolevel");
                SchemaInfoLevel schemaInfoLevel = InfoLevel.valueOf((String)infoLevel).getSchemaInfoLevel();
                this.options.setSchemaInfoLevel(schemaInfoLevel);
            }
            catch (IllegalArgumentException e) {
                this.options.setSchemaInfoLevel(SchemaInfoLevel.standard());
            }
        } else {
            throw new SchemaCrawlerException("No infolevel specified");
        }
        if (this.hasOptionValue("schemas")) {
            InclusionRule schemaInclusionRule = new InclusionRule(this.getStringValue("schemas"), "");
            this.options.setSchemaInclusionRule(schemaInclusionRule);
        }
        if (this.hasOptionValue("table_types")) {
            this.options.setTableTypes(this.getStringValue("table_types"));
        }
        if (this.hasOptionValue("tables")) {
            InclusionRule tableInclusionRule = new InclusionRule(this.getStringValue("tables"), "");
            this.options.setTableInclusionRule(tableInclusionRule);
        }
        if (this.hasOptionValue("excludecolumns")) {
            InclusionRule columnInclusionRule = new InclusionRule(".*", this.getStringValue("excludecolumns"));
            this.options.setColumnInclusionRule(columnInclusionRule);
        }
        if (this.hasOptionValue("procedures")) {
            InclusionRule procedureInclusionRule = new InclusionRule(this.getStringValue("procedures"), "");
            this.options.setProcedureInclusionRule(procedureInclusionRule);
        }
        if (this.hasOptionValue("excludeinout")) {
            InclusionRule procedureColumnInclusionRule = new InclusionRule(".*", this.getStringValue("excludeinout"));
            this.options.setProcedureColumnInclusionRule(procedureColumnInclusionRule);
        }
        if (this.hasOptionValue("v")) {
            this.options.setGrepInvertMatch(this.getBooleanValue("v"));
        }
        if (this.hasOptionValue("grepcolumns")) {
            InclusionRule grepColumnInclusionRule = new InclusionRule(this.getStringValue("grepcolumns"), "");
            this.options.setGrepColumnInclusionRule(grepColumnInclusionRule);
        } else {
            this.options.setGrepColumnInclusionRule(null);
        }
        if (this.hasOptionValue("grepinout")) {
            InclusionRule grepProcedureColumnInclusionRule = new InclusionRule(this.getStringValue("grepinout"), "");
            this.options.setGrepProcedureColumnInclusionRule(grepProcedureColumnInclusionRule);
        } else {
            this.options.setGrepProcedureColumnInclusionRule(null);
        }
        if (this.hasOptionValue("grepdef")) {
            InclusionRule grepDefinitionInclusionRule = new InclusionRule(this.getStringValue("grepdef"), "");
            this.options.setGrepDefinitionInclusionRule(grepDefinitionInclusionRule);
        } else {
            this.options.setGrepDefinitionInclusionRule(null);
        }
        if (this.hasOptionValue("sorttables")) {
            this.options.setAlphabeticalSortForTables(this.getBooleanValue("sorttables"));
        }
        if (this.hasOptionValue("sortcolumns")) {
            this.options.setAlphabeticalSortForTableColumns(this.getBooleanValue("sortcolumns"));
        }
        if (this.hasOptionValue("sortinout")) {
            this.options.setAlphabeticalSortForProcedureColumns(this.getBooleanValue("sortinout"));
        }
        return this.options;
    }
}

