/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.io.Serializable;

public abstract class Lint
implements Serializable,
Comparable<Lint> {
    private static final long serialVersionUID = -8627082144974643415L;
    public static final String LINT_KEY = "schemacrawler.lint";
    private final String description;
    private final Object lintValue;

    Lint(String description, Serializable lintValue) {
        this.description = description;
        this.lintValue = lintValue;
    }

    @Override
    public final int compareTo(Lint lint) {
        if (this.description == null || lint == null) {
            return -1;
        }
        return this.description.compareTo(lint.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Lint)) {
            return false;
        }
        Lint other = (Lint)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.lintValue == null ? other.lintValue != null : !this.lintValue.equals(other.lintValue));
    }

    public final String getDescription() {
        return this.description;
    }

    public final Object getLintValue() {
        return this.lintValue;
    }

    public abstract String getLintValueAsString();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.lintValue == null ? 0 : this.lintValue.hashCode());
        return result;
    }

    public String toString() {
        return this.description + "=" + this.getLintValueAsString();
    }
}

