/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.BaseLinter;
import schemacrawler.tools.analysis.Lint;
import sf.util.ObjectToString;
import sf.util.Utility;

public class LinterTableWithIncrementingColumns
extends BaseLinter<Table> {
    @Override
    public void lint(Table table) {
        HashMap<String, List<Column>> incrementingColumns;
        if (table != null && !(incrementingColumns = this.findIncrementingColumns(table.getColumns())).isEmpty()) {
            this.addLint(table, new Lint("incrementing columns", incrementingColumns){
                private static final long serialVersionUID = -9152369844685463520L;

                @Override
                public String getLintValueAsString() {
                    StringBuilder buffer = new StringBuilder();
                    for (List incrementingColumnsGroup : incrementingColumns.values()) {
                        ArrayList<String> columnNames = new ArrayList<String>();
                        for (Column column : incrementingColumnsGroup) {
                            columnNames.add(column.getName());
                        }
                        buffer.append(ObjectToString.toString(columnNames)).append(Utility.NEWLINE);
                    }
                    return buffer.toString();
                }
            });
        }
    }

    private HashMap<String, List<Column>> findIncrementingColumns(Column[] columns) {
        if (columns == null || columns.length <= 1) {
            return new HashMap<String, List<Column>>();
        }
        Pattern pattern = Pattern.compile("([^0-9]*)([0-9]+)");
        HashMap<String, Integer> incrementingColumnsMap = new HashMap<String, Integer>();
        for (Column column : columns) {
            String columnName = Utility.convertForComparison((String)column.getName());
            incrementingColumnsMap.put(columnName, 1);
            Matcher matcher = pattern.matcher(columnName);
            if (!matcher.matches()) continue;
            String columnNameBase = matcher.group(1);
            if (incrementingColumnsMap.containsKey(columnNameBase)) {
                incrementingColumnsMap.put(columnNameBase, (Integer)incrementingColumnsMap.get(columnNameBase) + 1);
                continue;
            }
            incrementingColumnsMap.put(columnNameBase, 1);
        }
        HashSet columnNameBases = new HashSet(incrementingColumnsMap.keySet());
        for (String columnNameBase : columnNameBases) {
            if ((Integer)incrementingColumnsMap.get(columnNameBase) != 1) continue;
            incrementingColumnsMap.remove(columnNameBase);
        }
        HashMap<String, List<Column>> incrementingColumns = new HashMap<String, List<Column>>();
        for (String columnNameBase : incrementingColumnsMap.keySet()) {
            incrementingColumns.put(columnNameBase, new ArrayList());
        }
        for (Column column : columns) {
            String columnNameBase;
            Matcher matcher;
            String columnName = Utility.convertForComparison((String)column.getName());
            if (incrementingColumnsMap.containsKey(columnName)) {
                incrementingColumns.get(columnName).add(column);
            }
            if (!(matcher = pattern.matcher(columnName)).matches() || !incrementingColumnsMap.containsKey(columnNameBase = matcher.group(1))) continue;
            incrementingColumns.get(columnNameBase).add(column);
        }
        return incrementingColumns;
    }
}

