/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.Executable;

public final class CommandRegistry {
    private static final Logger LOGGER = Logger.getLogger(CommandRegistry.class.getName());
    private final Map<String, String> commandRegistry = CommandRegistry.loadCommandRegistry();

    private static Map<String, String> loadCommandRegistry() throws SchemaCrawlerException {
        HashMap<String, String> commandRegistry = new HashMap<String, String>();
        HashSet<URL> commandRegistryUrls = new HashSet<URL>();
        try {
            ClassLoader classLoader = CommandRegistry.class.getClassLoader();
            Enumeration<URL> resources = classLoader.getResources("tools.command.properties");
            commandRegistryUrls.addAll(Collections.list(resources));
            resources = classLoader.getResources("command.properties");
            commandRegistryUrls.addAll(Collections.list(resources));
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not load command registry", (Throwable)e);
        }
        for (URL commandRegistryUrl : commandRegistryUrls) {
            try {
                Properties commandRegistryProperties = new Properties();
                commandRegistryProperties.load(commandRegistryUrl.openStream());
                ArrayList<String> propertyNames = Collections.list(commandRegistryProperties.propertyNames());
                for (String commandName : propertyNames) {
                    String executableClassName = commandRegistryProperties.getProperty(commandName);
                    commandRegistry.put(commandName, executableClassName);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not load command registry, " + commandRegistryUrl, e);
            }
        }
        if (commandRegistry.isEmpty()) {
            throw new SchemaCrawlerException("Could not load any command registry");
        }
        return commandRegistry;
    }

    public Executable instantiateExecutableForCommand(String command) throws SchemaCrawlerException {
        Executable executable;
        Class<?> commandExecutableClass;
        String commandExecutableClassName = this.lookupExecutableClassName(command);
        if (commandExecutableClassName == null) {
            throw new SchemaCrawlerException("No executable found for command '" + command + "'");
        }
        try {
            commandExecutableClass = Class.forName(commandExecutableClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load class " + commandExecutableClassName, (Throwable)e);
        }
        try {
            executable = (Executable)commandExecutableClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not instantiate " + commandExecutableClassName + " using the default constructor");
            try {
                Constructor<?> constructor = commandExecutableClass.getConstructor(String.class);
                executable = (Executable)constructor.newInstance(command);
            }
            catch (Exception e1) {
                throw new SchemaCrawlerException("Could not instantiate executable for command '" + command + "'", (Throwable)e1);
            }
        }
        return executable;
    }

    public String[] lookupAvailableCommands() {
        Set<String> availableCommandsList = this.commandRegistry.keySet();
        availableCommandsList.remove("default");
        Object[] availableCommands = availableCommandsList.toArray(new String[availableCommandsList.size()]);
        Arrays.sort(availableCommands);
        return availableCommands;
    }

    public String lookupExecutableClassName(String command) {
        String commandExecutableClassName = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command) : this.commandRegistry.get("default");
        return commandExecutableClassName;
    }
}

