/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.util.HtmlFormattingHelper;
import schemacrawler.tools.text.util.PlainTextFormattingHelper;
import schemacrawler.tools.text.util.TextFormattingHelper;
import sf.util.ObjectToString;

public abstract class BaseFormatter<O extends Options> {
    protected final O options;
    protected final OutputOptions outputOptions;
    protected final PrintWriter out;
    protected final TextFormattingHelper formattingHelper;
    protected final boolean printVerboseDatabaseInfo;

    protected BaseFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        if (options == null) {
            throw new IllegalArgumentException("Options not provided");
        }
        this.options = options;
        boolean bl = this.printVerboseDatabaseInfo = !outputOptions.isNoInfo() && printVerboseDatabaseInfo;
        if (outputOptions == null) {
            throw new IllegalArgumentException("Output options not provided");
        }
        this.outputOptions = outputOptions;
        OutputFormat outputFormat = outputOptions.getOutputFormat();
        this.formattingHelper = outputFormat == OutputFormat.html ? new HtmlFormattingHelper(outputFormat) : new PlainTextFormattingHelper(outputFormat);
        this.out = outputOptions.openOutputWriter();
    }

    public final void handle(SchemaCrawlerInfo schemaCrawlerInfo, DatabaseInfo databaseInfo, JdbcDriverInfo jdbcDriverInfo) throws SchemaCrawlerException {
        if (this.outputOptions.isNoInfo()) {
            return;
        }
        if (schemaCrawlerInfo != null && databaseInfo != null && jdbcDriverInfo != null) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information"));
        }
        this.handle(schemaCrawlerInfo);
        this.handle(databaseInfo);
        this.handle(jdbcDriverInfo);
    }

    private void handle(DatabaseInfo dbInfo) {
        if (dbInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("database product name", dbInfo.getProductName()));
        this.out.println(this.formattingHelper.createNameValueRow("database product version", dbInfo.getProductVersion()));
        this.out.println(this.formattingHelper.createNameValueRow("database user name", dbInfo.getUserName()));
        this.out.print(this.formattingHelper.createObjectEnd());
        if (this.printVerboseDatabaseInfo && dbInfo.getProperties().length > 0) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Characteristics"));
            this.out.print(this.formattingHelper.createObjectStart(""));
            for (DatabaseProperty property : dbInfo.getProperties()) {
                String name = property.getDescription();
                Object value = property.getValue();
                if (value == null) {
                    value = "";
                }
                this.out.println(this.formattingHelper.createNameValueRow(name, ObjectToString.toString((Object)value)));
            }
            this.out.print(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    private void handle(JdbcDriverInfo driverInfo) {
        if (driverInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("driver name", driverInfo.getDriverName()));
        this.out.println(this.formattingHelper.createNameValueRow("driver version", driverInfo.getDriverVersion()));
        this.out.println(this.formattingHelper.createNameValueRow("driver class name", driverInfo.getDriverClassName()));
        this.out.println(this.formattingHelper.createNameValueRow("url", driverInfo.getConnectionUrl()));
        this.out.println(this.formattingHelper.createNameValueRow("is JDBC compliant", Boolean.toString(driverInfo.isJdbcCompliant())));
        this.out.print(this.formattingHelper.createObjectEnd());
        JdbcDriverProperty[] jdbcDriverProperties = driverInfo.getDriverProperties();
        if (this.printVerboseDatabaseInfo && jdbcDriverProperties.length > 0) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Properties"));
            for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                this.out.print(this.formattingHelper.createObjectStart(""));
                this.printJdbcDriverProperty(driverProperty);
                this.out.print(this.formattingHelper.createObjectEnd());
            }
        }
        this.out.flush();
    }

    private void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        TreeMap systemProperties;
        if (schemaCrawlerInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "SchemaCrawler Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("product name", schemaCrawlerInfo.getSchemaCrawlerProductName()));
        this.out.println(this.formattingHelper.createNameValueRow("product version", schemaCrawlerInfo.getSchemaCrawlerVersion()));
        this.out.print(this.formattingHelper.createObjectEnd());
        if (this.printVerboseDatabaseInfo && !(systemProperties = new TreeMap(schemaCrawlerInfo.getSystemProperties())).isEmpty()) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "System Properties"));
            this.out.print(this.formattingHelper.createObjectStart(""));
            for (Map.Entry systemProperty : systemProperties.entrySet()) {
                this.out.println(this.formattingHelper.createNameValueRow((String)systemProperty.getKey(), (String)systemProperty.getValue()));
            }
            this.out.print(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    private void printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        String required;
        String choices = Arrays.asList(driverProperty.getChoices()).toString();
        String details = required = (driverProperty.isRequired() ? "" : "not ") + "required";
        if (driverProperty.getChoices() != null && driverProperty.getChoices().length > 0) {
            details = details + "; choices " + choices;
        }
        String value = driverProperty.getValue();
        this.out.println(this.formattingHelper.createNameRow(driverProperty.getName(), "[driver property]", false));
        this.out.println(this.formattingHelper.createDescriptionRow(driverProperty.getDescription()));
        this.out.println(this.formattingHelper.createDescriptionRow(details));
        this.out.println(this.formattingHelper.createDetailRow("", "value", value));
    }
}

