/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.serialization.SerializableDatabase;

public final class YamlDatabase
implements SerializableDatabase {
    private static final long serialVersionUID = 5314326260124511414L;
    private final Database database;

    private static Yaml newYaml() throws SchemaCrawlerException {
        Yaml yaml = new Yaml();
        return yaml;
    }

    public YamlDatabase(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("No database provided");
        }
        this.database = database;
    }

    public YamlDatabase(Reader reader) throws SchemaCrawlerException {
        this((Database)YamlDatabase.newYaml().load(reader));
    }

    public int compareTo(NamedObject o) {
        return this.database.compareTo((Object)o);
    }

    public boolean equals(Object obj) {
        return this.database.equals(obj);
    }

    public Object getAttribute(String name) {
        return this.database.getAttribute(name);
    }

    public <T> T getAttribute(String name, T defaultValue) {
        return (T)this.database.getAttribute(name, defaultValue);
    }

    public Map<String, Object> getAttributes() {
        return this.database.getAttributes();
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.database.getDatabaseInfo();
    }

    public String getFullName() {
        return this.database.getFullName();
    }

    public JdbcDriverInfo getJdbcDriverInfo() {
        return this.database.getJdbcDriverInfo();
    }

    public String getName() {
        return this.database.getName();
    }

    public String getRemarks() {
        return this.database.getRemarks();
    }

    public Schema getSchema(String schemaName) {
        return this.database.getSchema(schemaName);
    }

    public SchemaCrawlerInfo getSchemaCrawlerInfo() {
        return this.database.getSchemaCrawlerInfo();
    }

    public Schema[] getSchemas() {
        return this.database.getSchemas();
    }

    public ColumnDataType getSystemColumnDataType(String name) {
        return this.database.getSystemColumnDataType(name);
    }

    public ColumnDataType[] getSystemColumnDataTypes() {
        return this.database.getSystemColumnDataTypes();
    }

    public int hashCode() {
        return this.database.hashCode();
    }

    @Override
    public void save(Writer writer) throws SchemaCrawlerException {
        if (writer == null) {
            throw new SchemaCrawlerException("Writer not provided");
        }
        try {
            YamlDatabase.newYaml().dump((Object)this.database, writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not write XML", (Throwable)e);
        }
    }

    public void setAttribute(String name, Object value) {
        this.database.setAttribute(name, value);
    }
}

