/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import sf.util.Utility;

public final class InclusionRule
implements Serializable {
    public static final String NONE = "";
    public static final String ALL = ".*";
    private static final Logger LOGGER = Logger.getLogger(InclusionRule.class.getName());
    private static final long serialVersionUID = 3443758881974362293L;
    private final Pattern patternInclude;
    private final Pattern patternExclude;
    public static InclusionRule INCLUDE_ALL = new InclusionRule(".*", "");
    public static InclusionRule EXCLUDE_ALL = new InclusionRule("", "");

    public InclusionRule(Pattern patternInclude, Pattern patternExclude) {
        this.patternInclude = patternInclude;
        this.patternExclude = patternExclude;
    }

    public InclusionRule(String patternInclude, String patternExclude) {
        this(Pattern.compile(patternInclude), Pattern.compile(patternExclude));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InclusionRule other = (InclusionRule)obj;
        if (this.patternExclude == null ? other.patternExclude != null : !this.patternExclude.pattern().equals(other.patternExclude.pattern())) {
            return false;
        }
        return !(this.patternInclude == null ? other.patternInclude != null : !this.patternInclude.pattern().equals(other.patternInclude.pattern()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.patternExclude == null ? 0 : this.patternExclude.hashCode());
        result = 31 * result + (this.patternInclude == null ? 0 : this.patternInclude.hashCode());
        return result;
    }

    public boolean include(String name) {
        String actionMessage;
        boolean include = false;
        if (!Utility.isBlank(name)) {
            if (!this.patternInclude.matcher(name).matches()) {
                actionMessage = "Excluding " + name + " since it does not match the include pattern";
            } else if (this.patternExclude.matcher(name).matches()) {
                actionMessage = "Excluding " + name + " since it matches the exclude pattern";
            } else {
                actionMessage = "Including " + name;
                include = true;
            }
        } else {
            actionMessage = "Excluding, since name is bank";
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            StackTraceElement caller = new Exception().getStackTrace()[1];
            LOGGER.logp(Level.FINE, caller.getClassName(), caller.getMethodName(), actionMessage);
        }
        return include;
    }

    public String toString() {
        return String.format("%s@%h-[:include:%s:exclude:%s:]", this.getClass().getSimpleName(), System.identityHashCode(this), this.patternInclude.pattern(), this.patternExclude.pattern());
    }
}

